/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;

public class DSTextHover
extends PDETextHover {
    private PDESourcePage fSourcePage;

    public DSTextHover(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        int offset = hoverRegion.getOffset();
        IDocumentRange range = this.fSourcePage.getRangeElement(offset, true);
        if (range instanceof IDocumentTextNode) {
            return this.checkTranslatedValue((IDocumentTextNode)range);
        }
        if (!(range instanceof IDSObject)) {
            return null;
        }
        return ((IDSObject)range).getName();
    }

    private String checkTranslatedValue(IDocumentTextNode node) {
        String value = node.getText();
        if (value.startsWith("%")) {
            return ((IPluginObject)node.getEnclosingElement()).getResourceString(value);
        }
        return null;
    }
}

