/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Random;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.StochasticPoissonSIDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;

public class StochasticPoissonSIDiseaseModelImpl
extends SIImpl
implements StochasticPoissonSIDiseaseModel {
    private Random rand = new Random();

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SILabelValue currentSI = (SILabelValue)currentState;
            double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSI.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            int S = (int)currentSI.getS();
            double prob = 0.0;
            prob = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * effectiveInfectious;
            double rndVar = this.rand.nextDouble();
            int pickN = 0;
            pickN = new BinomialDistributionUtil(1L).fastPickFromBinomialDist(prob, S);
            double numberOfSusceptibleToInfected = pickN;
            double numberOfInfectedToSusceptible = this.getAdjustedRecoveryRate(timeDelta) * currentSI.getI();
            double deltaS = -numberOfSusceptibleToInfected + numberOfInfectedToSusceptible;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToSusceptible;
            SILabelValueImpl ret = (SILabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STOCHASTIC_POISSON_SI_DISEASE_MODEL;
    }
}

