/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

public class TypeParameterScope
extends AbstractScope {
    private final AbstractScope parent;
    private final List<List<JvmTypeParameter>> typeParameters;

    public TypeParameterScope(List<List<JvmTypeParameter>> typeParameters, AbstractScope parent) {
        this.typeParameters = typeParameters;
        this.parent = parent;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null) {
            return result;
        }
        return this.parent.getSingleElement(name);
    }

    protected IEObjectDescription doGetSingleElement(QualifiedName name) {
        if (name.getSegmentCount() == 1) {
            String singleSegment = name.getFirstSegment();
            int i = 0;
            while (i < this.typeParameters.size()) {
                List<JvmTypeParameter> chunk = this.typeParameters.get(i);
                int j = 0;
                while (j < chunk.size()) {
                    JvmTypeParameter candidate = chunk.get(j);
                    if (singleSegment.equals(candidate.getSimpleName())) {
                        return EObjectDescription.create((QualifiedName)name, (EObject)candidate);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null) {
            return Collections.singletonList(result);
        }
        return this.parent.getElements(name);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        if (type instanceof JvmTypeParameter) {
            JvmTypeParameter casted = (JvmTypeParameter)type;
            QualifiedName name = QualifiedName.create((String)casted.getSimpleName());
            IEObjectDescription candidate = this.doGetSingleElement(name);
            if (candidate != null && candidate.getEObjectOrProxy() == type) {
                result.add(candidate);
            }
            return;
        }
        this.parent.doGetElements(type, result);
    }
}

