/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class RemoveSynchronizeParticipantAction
extends Action {
    private final ISynchronizeView view;
    private boolean removeAll;

    public RemoveSynchronizeParticipantAction(ISynchronizeView view, boolean removeAll) {
        this.view = view;
        this.removeAll = removeAll;
        if (removeAll) {
            Utils.initAction((IAction)this, "action.removeAllPage.");
        } else {
            Utils.initAction((IAction)this, "action.removePage.");
        }
    }

    public void run() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                if (this.removeAll) {
                    this.removeAll();
                } else {
                    this.removeCurrent();
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void removeCurrent() {
        ISynchronizeParticipant participant = this.view.getParticipant();
        if (participant != null) {
            List<Saveable> dirtyModels = this.getDirtyModels(new ISynchronizeParticipant[]{participant});
            if (participant.isPinned() || !dirtyModels.isEmpty()) {
                boolean[] keepGoing = new boolean[1];
                Display.getDefault().syncExec(() -> {
                    blArray[0] = !dirtyModels.isEmpty() ? this.promptToSave(dirtyModels) : MessageDialog.openQuestion((Shell)this.view.getSite().getShell(), (String)TeamUIMessages.RemoveSynchronizeParticipantAction_0, (String)TeamUIMessages.RemoveSynchronizeParticipantAction_1);
                });
                if (!keepGoing[0]) {
                    return;
                }
            }
            TeamUI.getSynchronizeManager().removeSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        }
    }

    private void removeAll() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipantReference[] refs = manager.getSynchronizeParticipants();
        ArrayList<ISynchronizeParticipant> removals = new ArrayList<ISynchronizeParticipant>();
        int i = 0;
        while (i < refs.length) {
            ISynchronizeParticipantReference reference = refs[i];
            try {
                ISynchronizeParticipant p = reference.getParticipant();
                if (!p.isPinned()) {
                    removals.add(p);
                }
            }
            catch (TeamException teamException) {}
            ++i;
        }
        ISynchronizeParticipant[] toRemove = removals.toArray(new ISynchronizeParticipant[removals.size()]);
        List<Saveable> dirtyModels = this.getDirtyModels(toRemove);
        if (!dirtyModels.isEmpty()) {
            boolean[] keepGoing = new boolean[1];
            Display.getDefault().syncExec(() -> {
                if (!dirtyModels.isEmpty()) {
                    blArray[0] = this.promptToSave(dirtyModels);
                }
            });
            if (!keepGoing[0]) {
                return;
            }
        }
        manager.removeSynchronizeParticipants(toRemove);
    }

    private boolean promptToSave(List dirtyModels) {
        block11: {
            block10: {
                if (dirtyModels.size() != 1) break block10;
                Saveable model = (Saveable)dirtyModels.get(0);
                String message = NLS.bind((String)TeamUIMessages.RemoveSynchronizeParticipantAction_2, (Object)model.getName());
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog d = new MessageDialog(this.view.getSite().getShell(), TeamUIMessages.RemoveSynchronizeParticipantAction_3, null, message, 3, buttons, 0);
                int choice = d.open();
                switch (choice) {
                    case 0: {
                        break block11;
                    }
                    case 1: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ListSelectionDialog dlg = new ListSelectionDialog(this.view.getSite().getShell(), (Object)dirtyModels, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), TeamUIMessages.RemoveSynchronizeParticipantAction_4);
            dlg.setInitialSelections(dirtyModels.toArray());
            dlg.setTitle(TeamUIMessages.RemoveSynchronizeParticipantAction_5);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            dirtyModels = Arrays.asList(dlg.getResult());
        }
        if (dirtyModels.isEmpty()) {
            return true;
        }
        List<Object> finalModels = dirtyModels;
        IRunnableWithProgress progressOp = monitor -> {
            monitor.beginTask(null, finalModels.size());
            for (Saveable model : finalModels) {
                if (model.isDirty()) {
                    try {
                        model.doSave((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)this.view.getSite().getShell(), null, (String)e.getMessage(), (IStatus)e.getStatus());
                    }
                }
                if (monitor.isCanceled()) break;
            }
            monitor.done();
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, progressOp);
        }
        catch (InvocationTargetException e) {
            Utils.handleError(this.view.getSite().getShell(), e, null, null);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private List<Saveable> getDirtyModels(ISynchronizeParticipant[] participants) {
        ArrayList<Saveable> result = new ArrayList<Saveable>();
        int i = 0;
        while (i < participants.length) {
            ModelSynchronizeParticipant msp;
            SaveableComparison s;
            ISynchronizeParticipant participant = participants[i];
            if (participant instanceof ModelSynchronizeParticipant && (s = (msp = (ModelSynchronizeParticipant)participant).getActiveSaveable()) != null && s.isDirty()) {
                result.add(s);
            }
            ++i;
        }
        return result;
    }
}

