/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.coord;

import java.util.HashMap;
import java.util.Map;

public class Ellipsoid {
    private final double majorAxis;
    private final double minorAxis;
    private final double flattening;
    public static String DEFAULT_ELLIPSOID_NAME = "WGS_1984";
    private static final Map<String, Ellipsoid> COMMON_ELLIPSOIDS = new HashMap<String, Ellipsoid>();

    static {
        COMMON_ELLIPSOIDS.put("WGS_1984", new Ellipsoid(6378137.0, 298.257223563));
        COMMON_ELLIPSOIDS.put("GRS_1980", new Ellipsoid(6378137.0, 298.257222101));
    }

    public Ellipsoid(double majorAxis, double flattening) {
        this.majorAxis = majorAxis;
        this.flattening = flattening;
        this.minorAxis = flattening != 0.0 ? majorAxis - majorAxis / flattening : majorAxis;
    }

    public static Ellipsoid getDefaultEllipsoid() {
        return COMMON_ELLIPSOIDS.get(DEFAULT_ELLIPSOID_NAME);
    }

    public static Ellipsoid getForName(String name) {
        return COMMON_ELLIPSOIDS.get(name);
    }

    public double getMajorAxis() {
        return this.majorAxis;
    }

    public double getMinorAxis() {
        return this.minorAxis;
    }

    public double getFlattening() {
        return this.flattening;
    }

    public double getEccentricity() {
        return Math.sqrt(this.getEccentricitySquared());
    }

    public double getEccentricitySquared() {
        return 1.0 - this.minorAxis * this.minorAxis / (this.majorAxis * this.majorAxis);
    }

    public String toString() {
        return "Ellipsoid [majorAxis=" + this.majorAxis + ", minorAxis=" + this.minorAxis + ", flattening=" + this.flattening + ", eccentricity=" + this.getEccentricitySquared() + "]";
    }
}

