/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.command.adapter;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.command.adapter.CommandProviderAdapter;
import org.eclipse.equinox.console.commands.CommandsTracker;
import org.eclipse.equinox.console.commands.DisconnectCommand;
import org.eclipse.equinox.console.commands.EquinoxCommandProvider;
import org.eclipse.equinox.console.commands.HelpCommand;
import org.eclipse.equinox.console.commands.ManCommand;
import org.eclipse.equinox.console.telnet.TelnetCommand;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceTracker<StartLevel, StartLevel> startLevelManagerTracker;
    private ServiceTracker<ConditionalPermissionAdmin, ConditionalPermissionAdmin> condPermAdminTracker;
    private ServiceTracker<PermissionAdmin, PermissionAdmin> permissionAdminTracker;
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private static boolean isFirstProcessor = true;
    private static TelnetCommand telnetConnection = null;
    private ServiceTracker<CommandProcessor, ServiceTracker<ConsoleSession, CommandSession>> commandProcessorTracker;
    private ServiceTracker<CommandProvider, List<ServiceRegistration<?>>> commandProviderTracker;
    private EquinoxCommandProvider equinoxCmdProvider;

    public void start(BundleContext context) throws Exception {
        this.commandProviderTracker = new ServiceTracker(context, CommandProvider.class, (ServiceTrackerCustomizer)new CommandCustomizer(context));
        this.commandProviderTracker.open();
        this.commandProcessorTracker = new ServiceTracker(context, CommandProcessor.class, (ServiceTrackerCustomizer)new ProcessorCustomizer(context));
        this.commandProcessorTracker.open();
        this.condPermAdminTracker = new ServiceTracker(context, ConditionalPermissionAdmin.class, null);
        this.condPermAdminTracker.open();
        this.permissionAdminTracker = new ServiceTracker(context, PermissionAdmin.class, null);
        this.permissionAdminTracker.open();
        this.startLevelManagerTracker = new ServiceTracker(context, StartLevel.class, null);
        this.startLevelManagerTracker.open();
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class, null);
        this.packageAdminTracker.open();
        this.equinoxCmdProvider = new EquinoxCommandProvider(context, this);
        this.equinoxCmdProvider.startService();
        HelpCommand helpCommand = new HelpCommand(context);
        helpCommand.startService();
        ManCommand manCommand = new ManCommand(context);
        manCommand.startService();
        DisconnectCommand disconnectCommand = new DisconnectCommand(context);
        disconnectCommand.startService();
        CommandsTracker commandsTracker = new CommandsTracker(context);
        context.registerService(CommandsTracker.class.getName(), (Object)commandsTracker, null);
        this.startBundle("org.apache.felix.gogo.runtime", true);
        this.startBundle("org.apache.felix.gogo.shell", true);
        this.startBundle("org.apache.felix.gogo.command", false);
    }

    private void startBundle(String bsn, boolean required) throws BundleException {
        PackageAdmin pa = (PackageAdmin)this.packageAdminTracker.getService();
        if (pa != null) {
            Bundle[] shells = pa.getBundles(bsn, null);
            if (shells != null && shells.length > 0) {
                shells[0].start(1);
            } else if (required) {
                throw new BundleException("Missing required bundle: " + bsn);
            }
        }
    }

    public StartLevel getStartLevel() {
        return Activator.getServiceFromTracker(this.startLevelManagerTracker, StartLevel.class);
    }

    public PermissionAdmin getPermissionAdmin() {
        return Activator.getServiceFromTracker(this.permissionAdminTracker, PermissionAdmin.class);
    }

    public ConditionalPermissionAdmin getConditionalPermissionAdmin() {
        return Activator.getServiceFromTracker(this.condPermAdminTracker, ConditionalPermissionAdmin.class);
    }

    public PackageAdmin getPackageAdmin() {
        return Activator.getServiceFromTracker(this.packageAdminTracker, PackageAdmin.class);
    }

    private static <T> T getServiceFromTracker(ServiceTracker<?, T> tracker, Class<T> serviceClass) {
        if (tracker == null) {
            throw new IllegalStateException("Missing service: " + serviceClass);
        }
        Object result = tracker.getService();
        if (result == null) {
            throw new IllegalStateException("Missing service: " + serviceClass);
        }
        return (T)result;
    }

    Method[] getCommandMethods(Object command) {
        Method[] methods;
        ArrayList<Method> names = new ArrayList<Method>();
        Class<?> c = command.getClass();
        Method[] methodArray = methods = c.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] types;
            Method method = methodArray[n2];
            if (method.getName().startsWith("_") && method.getModifiers() == 1 && !method.getName().equals("_help") && (types = method.getGenericParameterTypes()).length == 1 && types[0].equals(CommandInterpreter.class)) {
                names.add(method);
            }
            ++n2;
        }
        return names.toArray(new Method[names.size()]);
    }

    Dictionary<String, Object> getAttributes(Method[] commandMethods) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "equinox");
        String[] methodNames = new String[commandMethods.length];
        int i = 0;
        while (i < commandMethods.length) {
            String methodName;
            methodNames[i] = methodName = commandMethods[i].getName().substring(1);
            ++i;
        }
        ((Dictionary)dict).put("osgi.command.function", methodNames);
        return dict;
    }

    public void stop(BundleContext context) throws Exception {
        this.commandProviderTracker.close();
        this.commandProcessorTracker.close();
        if (this.equinoxCmdProvider != null) {
            this.equinoxCmdProvider.stopService();
        }
        try {
            telnetConnection.telnet(new String[]{"stop"});
        }
        catch (Exception exception) {}
    }

    public class CommandCustomizer
    implements ServiceTrackerCustomizer<CommandProvider, List<ServiceRegistration<?>>> {
        private BundleContext context;

        public CommandCustomizer(BundleContext context) {
            this.context = context;
        }

        public List<ServiceRegistration<?>> addingService(ServiceReference<CommandProvider> reference) {
            if (reference.getProperty("osgi.command.function") != null) {
                return null;
            }
            CommandProvider command = (CommandProvider)this.context.getService(reference);
            try {
                Method[] commandMethods = Activator.this.getCommandMethods(command);
                if (commandMethods.length > 0) {
                    ArrayList registrations = new ArrayList();
                    registrations.add(this.context.registerService(Object.class, (Object)new CommandProviderAdapter(command, commandMethods), Activator.this.getAttributes(commandMethods)));
                    return registrations;
                }
                this.context.ungetService(reference);
                return null;
            }
            catch (Exception exception) {
                this.context.ungetService(reference);
                return null;
            }
        }

        public void modifiedService(ServiceReference<CommandProvider> reference, List<ServiceRegistration<?>> service) {
        }

        public void removedService(ServiceReference<CommandProvider> reference, List<ServiceRegistration<?>> registrations) {
            for (ServiceRegistration<?> serviceRegistration : registrations) {
                serviceRegistration.unregister();
            }
        }
    }

    public static class ProcessorCustomizer
    implements ServiceTrackerCustomizer<CommandProcessor, ServiceTracker<ConsoleSession, CommandSession>> {
        private final BundleContext context;

        public ProcessorCustomizer(BundleContext context) {
            this.context = context;
        }

        public ServiceTracker<ConsoleSession, CommandSession> addingService(ServiceReference<CommandProcessor> reference) {
            CommandProcessor processor = (CommandProcessor)this.context.getService(reference);
            if (processor == null) {
                return null;
            }
            if (isFirstProcessor) {
                isFirstProcessor = false;
                telnetConnection = new TelnetCommand(processor, this.context);
                telnetConnection.startService();
            } else {
                telnetConnection.addCommandProcessor(processor);
            }
            ServiceTracker tracker = new ServiceTracker(this.context, ConsoleSession.class, (ServiceTrackerCustomizer)new SessionCustomizer(this.context, processor));
            tracker.open();
            return tracker;
        }

        public void modifiedService(ServiceReference<CommandProcessor> reference, ServiceTracker<ConsoleSession, CommandSession> service) {
        }

        public void removedService(ServiceReference<CommandProcessor> reference, ServiceTracker<ConsoleSession, CommandSession> tracker) {
            tracker.close();
            CommandProcessor processor = (CommandProcessor)this.context.getService(reference);
            telnetConnection.removeCommandProcessor(processor);
        }
    }

    public static class SessionCustomizer
    implements ServiceTrackerCustomizer<ConsoleSession, CommandSession> {
        private final BundleContext context;
        final CommandProcessor processor;

        public SessionCustomizer(BundleContext context, CommandProcessor processor) {
            this.context = context;
            this.processor = processor;
        }

        public CommandSession addingService(ServiceReference<ConsoleSession> reference) {
            final ConsoleSession equinoxSession = (ConsoleSession)this.context.getService(reference);
            if (equinoxSession == null) {
                return null;
            }
            PrintStream output = new PrintStream(equinoxSession.getOutput());
            final CommandSession gogoSession = this.processor.createSession(equinoxSession.getInput(), (OutputStream)output, (OutputStream)output);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            gogoSession.put("SCOPE", (Object)"equinox:*");
                            gogoSession.put("prompt", (Object)"osgi> ");
                            gogoSession.execute((CharSequence)"gosh --login --noshutdown");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            gogoSession.close();
                            equinoxSession.close();
                        }
                    }
                    finally {
                        gogoSession.close();
                        equinoxSession.close();
                    }
                }
            }, "Equinox Console Session").start();
            return null;
        }

        public void modifiedService(ServiceReference<ConsoleSession> reference, CommandSession service) {
        }

        public void removedService(ServiceReference<ConsoleSession> reference, CommandSession session) {
            session.close();
        }
    }
}

