/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.ide.contentassist.IIdeTypesProposalProvider;
import org.eclipse.xtext.xbase.ide.contentassist.XbaseIdeContentProposalPriorities;
import org.eclipse.xtext.xbase.ide.types.ClasspathScanner;
import org.eclipse.xtext.xbase.ide.types.ITypeDescriptor;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.ImportSectionRegionUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

public class ClasspathBasedIdeTypesProposalProvider
implements IIdeTypesProposalProvider {
    @Inject
    private ClassLoader classLoader;
    @Inject
    private ClasspathScanner classpathScanner;
    @Inject
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private ImportSectionRegionUtil importSectionRegionUtil;

    @Override
    public void createTypeProposals(EReference reference, ContentAssistContext context, Predicate<ITypeDescriptor> filter, IIdeContentProposalAcceptor acceptor) {
        boolean _not;
        ITextRegion importSectionRegion = null;
        XImportSection importSection = null;
        boolean _isImportDeclaration = this.isImportDeclaration(reference, context);
        boolean bl = _not = !_isImportDeclaration;
        if (_not) {
            importSection = this.importsConfiguration.getImportSection(context.getResource());
            importSectionRegion = this.importSectionRegionUtil.computeRegion(context.getResource());
        }
        Iterable<ITypeDescriptor> _typeDescriptors = this.getTypeDescriptors(context);
        for (ITypeDescriptor typeDesc : _typeDescriptors) {
            boolean _not_1;
            boolean _canAcceptMoreProposals = acceptor.canAcceptMoreProposals();
            boolean bl2 = _not_1 = !_canAcceptMoreProposals;
            if (_not_1) {
                return;
            }
            boolean _canPropose = this.canPropose(typeDesc, context, filter);
            if (!_canPropose) continue;
            ContentAssistEntry entry = this.createProposal(reference, typeDesc, context, importSection, importSectionRegion);
            int priority = ((XbaseIdeContentProposalPriorities)this.proposalPriorities).getTypeRefPriority(typeDesc, entry);
            acceptor.accept(entry, priority);
        }
    }

    protected Iterable<ITypeDescriptor> getTypeDescriptors(ContentAssistContext context) {
        Iterable<ITypeDescriptor> bootClasspath = this.classpathScanner.getBootClasspathDescriptors(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java"})));
        Iterable<ITypeDescriptor> appClasspath = this.classpathScanner.getDescriptors(this.getClassLoader(context), Collections.emptyList());
        return Iterables.concat(bootClasspath, appClasspath);
    }

    protected ClassLoader getClassLoader(ContentAssistContext context) {
        Object ctx;
        ResourceSet resourceSet = context.getResource().getResourceSet();
        if (resourceSet instanceof XtextResourceSet && (ctx = ((XtextResourceSet)resourceSet).getClasspathURIContext()) != null) {
            if (ctx instanceof Class) {
                return ((Class)ctx).getClassLoader();
            }
            if (ctx instanceof ClassLoader) {
                return (ClassLoader)ctx;
            }
            return ctx.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    protected boolean canPropose(ITypeDescriptor typeDesc, ContentAssistContext context, Predicate<ITypeDescriptor> filter) {
        return this.isVisible(typeDesc, context) && filter.apply((Object)typeDesc);
    }

    protected boolean isVisible(ITypeDescriptor typeDesc, ContentAssistContext context) {
        return (typeDesc.getAccessFlags() & 1) != 0;
    }

    protected ContentAssistEntry createProposal(EReference reference, ITypeDescriptor typeDesc, ContentAssistContext context, XImportSection importSection, ITextRegion importSectionRegion) {
        ContentAssistEntry _xblockexpression = null;
        boolean importDecl = this.isImportDeclaration(reference, context);
        String qualifiedName = this.qualifiedNameConverter.toString(typeDesc.getQualifiedName());
        String _xifexpression = null;
        _xifexpression = importDecl ? qualifiedName : typeDesc.getSimpleName();
        String proposal = _xifexpression;
        Procedures.Procedure1 _function = it -> {
            if (importDecl) {
                it.setLabel(typeDesc.getSimpleName());
                it.setDescription(proposal);
            } else {
                it.setDescription(qualifiedName);
                if (importSectionRegion != null && this.isImportDeclarationRequired(typeDesc, qualifiedName, context, importSection)) {
                    this.addImportDeclaration((ContentAssistEntry)it, importSectionRegion, typeDesc, qualifiedName, context);
                }
            }
        };
        _xblockexpression = this.proposalCreator.createProposal(proposal, context, _function);
        return _xblockexpression;
    }

    protected boolean isImportDeclaration(EReference reference, ContentAssistContext context) {
        return Objects.equal((Object)reference, (Object)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE);
    }

    protected boolean isImportDeclarationRequired(ITypeDescriptor typeDesc, String qualifiedName, ContentAssistContext context, XImportSection importSection) {
        return !(typeDesc.getName().startsWith("java.lang") && typeDesc.getName().lastIndexOf(".") == 9 || importSection != null && IterableExtensions.exists((Iterable)importSection.getImportDeclarations(), it -> {
            JvmDeclaredType _importedType = it.getImportedType();
            String _qualifiedName = null;
            if (_importedType != null) {
                _qualifiedName = _importedType.getQualifiedName();
            }
            return Objects.equal((Object)_qualifiedName, (Object)qualifiedName);
        }));
    }

    protected boolean addImportDeclaration(ContentAssistEntry entry, ITextRegion importSectionRegion, ITypeDescriptor typeDesc, String qualifiedName, ContentAssistContext context) {
        boolean _xblockexpression = false;
        int _offset = importSectionRegion.getOffset();
        int _length = importSectionRegion.getLength();
        int insertionOffset = _offset + _length;
        String declaration = "\nimport " + qualifiedName;
        ArrayList _textReplacements = entry.getTextReplacements();
        ReplaceRegion _replaceRegion = new ReplaceRegion(insertionOffset, 0, declaration);
        _xblockexpression = _textReplacements.add(_replaceRegion);
        return _xblockexpression;
    }
}

