/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;

public abstract class PlotComputation {
    protected static final ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation");
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    protected final IDisplayServer ids;
    protected final RunTimeContext rtc;
    protected final IChartComputation cComp;
    protected final Chart cm;
    protected Insets insCA = null;
    protected transient double dPointToPixel = 0.0;
    protected Bounds boPlotBackground = goFactory.createBounds(0.0, 0.0, 100.0, 100.0);

    public PlotComputation(IDisplayServer ids, RunTimeContext rtc, Chart cm) {
        this.rtc = rtc;
        this.cComp = rtc.getState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY);
        this.ids = ids;
        this.cm = cm;
        this.dPointToPixel = (double)ids.getDpiResolution() / 72.0;
    }

    public abstract void compute(Bounds var1) throws ChartException, IllegalArgumentException;

    public abstract ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition var1, Series var2) throws ChartException, IllegalArgumentException;

    public final Bounds getPlotBounds() {
        return this.boPlotBackground;
    }

    public Chart getModel() {
        return this.cm;
    }

    public final Insets getPlotInsets() {
        return this.insCA;
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public IChartComputation getChartComputation() {
        return this.cComp;
    }

    public double getPointToPixel() {
        return this.dPointToPixel;
    }
}

