/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class MessageLine
extends CLabel {
    private static final RGB ERROR_BACKGROUND_RGB = new RGB(230, 226, 221);
    private Color fNormalMsgAreaBackground = this.getBackground();
    private Color fErrorMsgAreaBackground = null;

    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public MessageLine(Composite parent, int style) {
        super(parent, style);
    }

    private Image findImage(IStatus status) {
        if (status.isOK()) {
            return null;
        }
        if (status.matches(4)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (status.matches(2)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (status.matches(1)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        return null;
    }

    public void setErrorStatus(IStatus status) {
        String message;
        if (status != null && (message = status.getMessage()) != null && message.length() > 0) {
            this.setText(message);
            this.setImage(this.findImage(status));
            if (this.fErrorMsgAreaBackground == null) {
                this.fErrorMsgAreaBackground = new Color((Device)this.getDisplay(), ERROR_BACKGROUND_RGB);
            }
            this.setBackground(this.fErrorMsgAreaBackground);
            return;
        }
        this.setText("");
        this.setImage(null);
        this.setBackground(this.fNormalMsgAreaBackground);
    }

    public void dispose() {
        if (this.fErrorMsgAreaBackground != null) {
            this.fErrorMsgAreaBackground.dispose();
            this.fErrorMsgAreaBackground = null;
        }
        super.dispose();
    }
}

