/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class GEViewLabelProvider
extends LabelProvider
implements IBaseLabelProvider {
    private GEInterface gei = null;

    public String getText(Object obj) {
        String flag = "";
        String template = "%s %s %s %s";
        String text = null;
        try {
            if (obj != null) {
                if (obj instanceof ISimulation) {
                    ISimulation sim = (ISimulation)obj;
                    String cycle = "";
                    String name = GEInterface.getSimulationId(sim);
                    if (this.gei.isActive(sim)) {
                        cycle = "[" + Integer.toString(this.gei.getCycle(sim)) + "]";
                        flag = "*";
                    }
                    if (this.gei.isActiveView(sim)) {
                        flag = "*GE";
                    }
                    text = String.format(template, flag, name, cycle, sim.toString());
                } else {
                    text = "" + obj;
                }
            } else {
                text = "null";
            }
        }
        catch (RuntimeException e) {
            GELog.error("Failure", e);
        }
        return text;
    }

    public Image getImage(Object obj) {
        GELog.debug(((Object)((Object)this)).getClass(), "getImage: obj=" + obj.toString());
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public void setGEI(GEInterface gei) {
        this.gei = gei;
    }

    public void setSelected(ISimulation selection) {
        GELog.debug(((Object)((Object)this)).getClass(), "setSelected");
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        this.fireLabelProviderChanged(event);
    }
}

