/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ScannerMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SystemApiDescriptionProcessor {
    private SystemApiDescriptionProcessor() {
    }

    public static String serializeComponentXml(File location) {
        if (location.exists()) {
            ZipFile jarFile = null;
            InputStream stream = null;
            try {
                String extension = new Path(location.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && location.isFile()) {
                    jarFile = new ZipFile(location, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("system.api_description");
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else if (location.isDirectory()) {
                    File file = new File(location, "system.api_description");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                } else if (location.isFile() && location.getName().equals("system.api_description")) {
                    stream = new FileInputStream(location);
                }
                if (stream != null) {
                    String string = new String(Util.getInputStreamAsCharArray(stream, -1, StandardCharsets.UTF_8));
                    return string;
                }
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.api.tools", message, exception);
        throw new CoreException((IStatus)status);
    }

    public static void annotateApiSettings(IApiDescription settings, String xml) throws CoreException {
        Element root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            SystemApiDescriptionProcessor.abort("Failed to parse API description xml file", ce);
        }
        if (!root.getNodeName().equals("component")) {
            SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_0, null);
        }
        NodeList packages = root.getElementsByTagName("package");
        NodeList types = null;
        IPackageDescriptor packdesc = null;
        Element type = null;
        int i = 0;
        while (i < packages.getLength()) {
            Element pkg = (Element)packages.item(i);
            String pkgName = pkg.getAttribute("name");
            packdesc = Factory.packageDescriptor(pkgName);
            SystemApiDescriptionProcessor.annotateDescriptor(settings, packdesc, pkg);
            types = pkg.getElementsByTagName("type");
            int j = 0;
            while (j < types.getLength()) {
                type = (Element)types.item(j);
                String name = type.getAttribute("name");
                if (name.length() == 0) {
                    SystemApiDescriptionProcessor.abort("Missing type name", null);
                }
                IReferenceTypeDescriptor typedesc = packdesc.getType(name);
                SystemApiDescriptionProcessor.annotateDescriptor(settings, typedesc, type);
                SystemApiDescriptionProcessor.annotateMethodSettings(settings, typedesc, type);
                SystemApiDescriptionProcessor.annotateFieldSettings(settings, typedesc, type);
                ++j;
            }
            ++i;
        }
    }

    private static void annotateDescriptor(IApiDescription settings, IElementDescriptor descriptor, Element element) {
        settings.setVisibility(descriptor, 1);
        settings.setRestrictions(descriptor, 0);
        settings.setAddedProfile(descriptor, SystemApiDescriptionProcessor.retrieveElementAttribute(element, "addedprofile"));
        settings.setRemovedProfile(descriptor, SystemApiDescriptionProcessor.retrieveElementAttribute(element, "removedprofile"));
        settings.setSuperclass(descriptor, SystemApiDescriptionProcessor.retrieveStringElementAttribute(element, "sc"));
        settings.setSuperinterfaces(descriptor, SystemApiDescriptionProcessor.retrieveStringElementAttribute(element, "sis"));
        settings.setInterface(descriptor, SystemApiDescriptionProcessor.retrieveBooleanElementAttribute(element, "int"));
    }

    private static int retrieveElementAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() > 0) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private static String retrieveStringElementAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() > 0) {
            return value;
        }
        return null;
    }

    private static boolean retrieveBooleanElementAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() > 0) {
            return Boolean.toString(true).equals(value);
        }
        return false;
    }

    private static void annotateFieldSettings(IApiDescription settings, IReferenceTypeDescriptor typedesc, Element type) throws CoreException {
        NodeList fields = type.getElementsByTagName("field");
        Element field = null;
        IFieldDescriptor fielddesc = null;
        String name = null;
        int i = 0;
        while (i < fields.getLength()) {
            field = (Element)fields.item(i);
            name = field.getAttribute("name");
            if (name == null) {
                SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_1, null);
            }
            fielddesc = typedesc.getField(name);
            SystemApiDescriptionProcessor.annotateDescriptor(settings, fielddesc, field);
            ++i;
        }
    }

    private static void annotateMethodSettings(IApiDescription settings, IReferenceTypeDescriptor typedesc, Element type) throws CoreException {
        NodeList methods = type.getElementsByTagName("method");
        Element method = null;
        IMethodDescriptor methoddesc = null;
        int i = 0;
        while (i < methods.getLength()) {
            String signature;
            method = (Element)methods.item(i);
            String name = method.getAttribute("name");
            if (name == null) {
                SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_2, null);
            }
            if ((signature = method.getAttribute("signature")) == null) {
                SystemApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_3, null);
            }
            methoddesc = typedesc.getMethod(name, signature);
            SystemApiDescriptionProcessor.annotateDescriptor(settings, methoddesc, method);
            ++i;
        }
    }
}

