/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.PopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelValueImpl;

public class StandardPopulationModelImpl
extends PopulationModelImpl
implements StandardPopulationModel {
    protected static final double BIRTH_RATE_EDEFAULT = 0.0;
    protected double birthRate = 0.0;
    protected static final double DEATH_RATE_EDEFAULT = 0.0;
    protected double deathRate = 0.0;

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_POPULATION_MODEL;
    }

    @Override
    public double getBirthRate() {
        return this.birthRate;
    }

    @Override
    public void setBirthRate(double newBirthRate) {
        this.birthRate = newBirthRate;
    }

    @Override
    public double getDeathRate() {
        return this.deathRate;
    }

    @Override
    public void setDeathRate(double newDeathRate) {
        this.deathRate = newDeathRate;
    }

    @Override
    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        super.decorateGraph(time);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getBirthRate();
            }
            case 17: {
                return this.getDeathRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setBirthRate((Double)newValue);
                return;
            }
            case 17: {
                this.setDeathRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setBirthRate(0.0);
                return;
            }
            case 17: {
                this.setDeathRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.birthRate != 0.0;
            }
            case 17: {
                return this.deathRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (birthRate: ");
        result.append(this.birthRate);
        result.append(", deathRate: ");
        result.append(this.deathRate);
        result.append(')');
        return result.toString();
    }

    @Override
    public PopulationModelLabel createPopulationModelLabel(String populationIdentifier) {
        StandardPopulationModelLabel retValue = StandardFactory.eINSTANCE.createStandardPopulationModelLabel();
        retValue.setTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        return retValue;
    }

    @Override
    public PopulationModelLabelValue createPopulationModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createStandardPopulationModelLabelValue();
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedBirthRate = this.adjustRate(this.getBirthRate(), this.getTimePeriod(), timeDelta);
        double adjustedDeathRate = this.adjustRate(this.getDeathRate(), this.getTimePeriod(), timeDelta);
        int i = 0;
        while (i < labels.size()) {
            StandardPopulationModelLabelImpl slabel = (StandardPopulationModelLabelImpl)labels.get(i);
            if (!this.checkAndAdjustForNegative(slabel)) {
                StandardPopulationModelLabelValueImpl delta = (StandardPopulationModelLabelValueImpl)slabel.getDeltaValue();
                StandardPopulationModelLabelValue current = (StandardPopulationModelLabelValue)slabel.getProbeValue();
                double currentPopulation = current.getCount();
                double births = currentPopulation * adjustedBirthRate;
                double deaths = currentPopulation * adjustedDeathRate;
                delta.setCount(births - deaths);
                delta.setBirths(births);
                delta.setDeaths(deaths);
                this.computeAdditionalDeltasAndExchanges(slabel, time, t, timeDelta);
            }
            ++i;
        }
    }

    protected double adjustRate(double rate, long ratePeriod, long actualPeriod) {
        return rate * ((double)actualPeriod / (double)ratePeriod);
    }
}

