/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.common;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ModelProjectUtils {
    private ModelProjectUtils() {
    }

    public static boolean isValidProject(IProject project) {
        try {
            return project.exists() && project.isOpen() && project.hasNature("org.eclipse.pde.PluginNature") && project.hasNature("org.eclipse.stem.model.common.ModelProjectNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void removeProjectNature(IProject project, String natureId) throws CoreException {
        if (project.exists() && project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            ArrayList<String> natures = new ArrayList<String>();
            natures.addAll(Arrays.asList(description.getNatureIds()));
            natures.remove(natureId);
            description.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void addProjectNature(IProject project, String natureId) throws CoreException {
        if (project.exists() && !project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            ArrayList<String> natures = new ArrayList<String>();
            natures.addAll(Arrays.asList(description.getNatureIds()));
            natures.add(natureId);
            description.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

