/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.stem.model.codegen.CodeGenConstants;
import org.eclipse.stem.model.codegen.ModelGeneratorDescriptors;
import org.eclipse.stem.model.codegen.descriptor.ModelGeneratorDescriptor;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.CompartmentType;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.ModelType;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.EPackageManager;

public class EcoreToMetamodelTransformer
implements IApplication {
    private Map<EClass, Model> modelMap = new HashMap<EClass, Model>();
    private Map<EClass, CompartmentGroup> labelMap = new HashMap<EClass, CompartmentGroup>();

    public Object start(IApplicationContext context) throws Exception {
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(wsr.getProject("org.eclipse.stem.diseasemodels"));
        projects.add(wsr.getProject("org.eclipse.stem.populationmodels"));
        projects.add(wsr.getProject("org.eclipse.stem.diseasemodels.vector"));
        projects.add(wsr.getProject("org.eclipse.stem.diseasemodels.multipopulation"));
        projects.add(wsr.getProject("org.eclipse.stem.diseasemodels.globalinfluenzamodel"));
        projects.add(wsr.getProject("org.eclipse.stem.diseasemodels.forcing"));
        List<EPackage> pkgs = this.loadProjectsInOrder(projects);
        System.out.println(pkgs);
        this.preProcess(pkgs);
        this.process(pkgs);
        Thread.sleep(1000L);
        return Status.OK_STATUS;
    }

    private List<EPackage> loadProjectsInOrder(List<IProject> projects) {
        ArrayList<EPackage> pkgs = new ArrayList<EPackage>();
        Map<IProject, List<IFile>> files = EPackageManager.getInstance().findECoresInWorkspace((IProgressMonitor)new NullProgressMonitor());
        for (IProject project : projects) {
            List<IFile> ecores = files.get(project);
            if (ecores == null) continue;
            for (IFile ecore : ecores) {
                URI ecoreURI = URI.createPlatformResourceURI((String)ecore.getFullPath().toString(), (boolean)true);
                try {
                    EObject obj = EPackageManager.getInstance().load(ecoreURI);
                    if (!(obj instanceof EPackage)) continue;
                    pkgs.add((EPackage)obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return pkgs;
    }

    private void process(Collection<EPackage> pkgs) {
        for (EPackage pkg : pkgs) {
            this.process(pkg);
        }
    }

    private void serialize(Package pkg, EPackage ePkg) {
        URI eCoreURI = ePkg.eResource().getURI();
        URI metamodelURI = URI.createPlatformResourceURI((String)eCoreURI.toPlatformString(true).replace(".ecore", ".metamodel"), (boolean)true);
        ResourceSet rs = EPackageManager.getInstance().getResourceSet();
        try {
            Resource r = rs.createResource(metamodelURI);
            r.getContents().add((Object)pkg);
            r.save(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process(EPackage ePkg) {
        Package pkg = MetamodelFactory.eINSTANCE.createPackage();
        pkg.setName(ePkg.getName());
        pkg.setPackagePrefix(ePkg.getNsPrefix());
        for (EClassifier classifier : ePkg.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            this.process(pkg, (EClass)classifier);
        }
        this.assignGroupsToModels(pkg);
        if (pkg.getModels().size() > 0) {
            this.serialize(pkg, ePkg);
        }
    }

    private void process(Package pkg, EClass eClass) {
        CompartmentGroup cg;
        Model m = this.modelMap.get(eClass);
        if (m != null && (m = this.processModel(m)) != null) {
            pkg.getModels().add((Object)m);
        }
        if ((cg = this.labelMap.get(eClass)) != null && (cg = this.processCompartmentGroup(cg)) != null) {
            pkg.getCompartmentGroups().add((Object)cg);
        }
    }

    private void assignGroupsToModels(Package pkg) {
        block0: for (Model m : pkg.getModels()) {
            for (CompartmentGroup cg : pkg.getCompartmentGroups()) {
                if (!cg.getName().equals(m.getName())) continue;
                m.setCompartments(cg);
                continue block0;
            }
        }
    }

    private CompartmentGroup processCompartmentGroup(CompartmentGroup cg) {
        EClass labelValueClass = cg.getValueClass();
        EClass labelClass = (EClass)labelValueClass.getEPackage().getEClassifier(labelValueClass.getName().replace("Value", ""));
        cg.setName(labelClass.getName().replace("Label", ""));
        cg.setClass(labelClass);
        CompartmentGroup parentCG = this.getParentCGFromMap(cg);
        if (parentCG == null && !"PopulationModel".equals(cg.getName()) && !"DiseaseModel".equals(cg.getName())) {
            EClass parentClass = (EClass)labelClass.getESuperTypes().get(0);
            System.err.println("Null CG parent: " + cg + " <= " + parentClass.getName() + " (" + parentClass.eResource() + ")");
            return null;
        }
        cg.setParentGroup(parentCG);
        this.collectCompartments(cg);
        return cg;
    }

    private CompartmentType getTypeForAttribute(EAttribute attr) {
        if (attr.getName().toLowerCase().contains("incidence")) {
            return CompartmentType.INCIDENCE;
        }
        if (attr.getName().toLowerCase().contains("deaths")) {
            return CompartmentType.DEATHS;
        }
        return CompartmentType.STANDARD;
    }

    private void collectCompartments(CompartmentGroup cg) {
        for (EAttribute attr : cg.getValueClass().getEAttributes()) {
            Compartment compartment = MetamodelFactory.eINSTANCE.createCompartment();
            compartment.setDataType(EcorePackage.Literals.EDOUBLE);
            compartment.setName(attr.getName());
            compartment.setType(this.getTypeForAttribute(attr));
            cg.getCompartments().add((Object)compartment);
        }
    }

    private Model processModel(Model m) {
        EClass eClass = m.getClass_();
        m.setName(eClass.getName());
        Model parentModel = this.getParentModelFromMap(m);
        if (m.getName().contains("Deterministic") || m.getName().contains("Stochastic")) {
            System.out.println("Excluding " + m.getName());
            return null;
        }
        if (parentModel == null && !"PopulationModel".equals(m.getName()) && !"DiseaseModel".equals(m.getName())) {
            EClass parentClass = (EClass)eClass.getESuperTypes().get(0);
            System.err.println("Null Model Parent: " + m + " <= " + parentClass.getName() + " (" + parentClass.eResource() + ")");
            return null;
        }
        m.setParentModel(parentModel);
        ModelGeneratorDescriptor descriptor = ModelGeneratorDescriptors.getInstance().getDescriptorForEClass(eClass);
        if (descriptor != null) {
            ModelType type = ModelType.get((String)descriptor.getModelType());
            m.setModelType(type);
        }
        this.collectModelParams(m);
        return m;
    }

    private void collectModelParams(Model model) {
        ModelParam param;
        EClass eClass = model.getClass_();
        for (EAttribute attr : eClass.getEAttributes()) {
            param = MetamodelFactory.eINSTANCE.createModelParam();
            if (attr.getEType() instanceof EDataType) {
                param.setDataType((EClassifier)((EDataType)attr.getEType()));
            } else {
                System.err.println("Unsupported data type for " + attr.getName() + ": " + attr.getEType());
                param.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
            }
            param.setName(attr.getName());
            param.setDefaultValue(attr.getDefaultValueLiteral());
            param.setDisplayName(this.formatString(attr.getName()));
            model.getParameters().add((Object)param);
        }
        for (EReference ref : eClass.getEReferences()) {
            param = MetamodelFactory.eINSTANCE.createModelParam();
            param.setName(ref.getName());
            param.setDataType(ref.getEType());
            param.setDefaultValue(ref.getDefaultValueLiteral());
            param.setDisplayName(this.formatString(ref.getName()));
            model.getParameters().add((Object)param);
        }
    }

    private String formatString(String data) {
        StringBuilder sb = new StringBuilder();
        char[] chars = data.toCharArray();
        sb.append(Character.toUpperCase(chars[0]));
        int idx = 1;
        while (idx < chars.length) {
            if (Character.isUpperCase(chars[idx]) && (Character.isLowerCase(chars[idx - 1]) || chars.length > idx + 1 && Character.isLowerCase(chars[idx + 1]))) {
                sb.append(" ");
            }
            sb.append(chars[idx]);
            ++idx;
        }
        return sb.toString();
    }

    private Model getParentModelFromMap(Model m) {
        EClass parentClass = (EClass)m.getClass_().getESuperTypes().get(0);
        Model parentModel = this.modelMap.get(parentClass);
        if (parentModel == null) {
            for (Map.Entry<EClass, Model> entry : this.modelMap.entrySet()) {
                EClass eClass = entry.getKey();
                if (!eClass.getEPackage().getNsURI().equals(parentClass.getEPackage().getNsURI()) || !eClass.getName().equals(parentClass.getName())) continue;
                parentModel = entry.getValue();
            }
        }
        return parentModel;
    }

    private CompartmentGroup getParentCGFromMap(CompartmentGroup cg) {
        EClass parentClass = (EClass)cg.getValueClass().getESuperTypes().get(0);
        CompartmentGroup parentGroup = this.labelMap.get(parentClass);
        if (parentGroup == null) {
            for (Map.Entry<EClass, CompartmentGroup> entry : this.labelMap.entrySet()) {
                EClass eClass = entry.getKey();
                if (!eClass.getEPackage().getNsURI().equals(parentClass.getEPackage().getNsURI()) || !eClass.getName().equals(parentClass.getName())) continue;
                parentGroup = entry.getValue();
            }
        }
        return parentGroup;
    }

    private String classToString(Object object) {
        return String.valueOf(object.getClass().getName()) + "@" + Integer.toHexString(object.hashCode());
    }

    private void preProcess(Collection<EPackage> pkgs) {
        for (EPackage pkg : pkgs) {
            for (EClassifier classifier : pkg.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                this.preProcessEClass((EClass)classifier);
            }
        }
    }

    private void preProcessEClass(EClass eClass) {
        if (CodeGenConstants.INTEGRATION_DECORATOR_DESCRIPTOR.isSuperTypeOf(eClass)) {
            Model m = MetamodelFactory.eINSTANCE.createModel();
            m.setClass(eClass);
            this.modelMap.put(eClass, m);
        }
        if (CodeGenConstants.INTEGRATION_LABEL_VALUE_DESCRIPTOR.isSuperTypeOf(eClass)) {
            CompartmentGroup cg = MetamodelFactory.eINSTANCE.createCompartmentGroup();
            cg.setValueClass(eClass);
            this.labelMap.put(eClass, cg);
        }
    }

    public void stop() {
    }
}

