/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sphinx.emf.validation.ui.views.IField;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerList;

public class TableComparator
extends ViewerComparator
implements Comparator {
    public static final int MAX_DEPTH = 4;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    protected IField[] fields;
    protected int[] priorities;
    protected int[] directions;
    protected int[] defaultPriorities;
    protected int[] defaultDirections;
    public static final String TAG_DIALOG_SECTION = "sorter";
    private static final String TAG_PRIORITY = "priority";
    private static final String TAG_DIRECTION = "direction";
    private static final String TAG_DEFAULT_PRIORITY = "defaultPriority";
    private static final String TAG_DEFAULT_DIRECTION = "defaultDirection";

    public TableComparator(TableComparator other) {
        this(other.getFields(), other.getDefaultPriorities(), other.getDefaultDirections());
        this.priorities = other.getPriorities();
        this.directions = other.getDirections();
    }

    public TableComparator(IField[] properties, int[] defaultPriorities, int[] defaultDirections) {
        this.fields = properties;
        if (properties == null || defaultPriorities == null || defaultDirections == null || properties.length != defaultPriorities.length || properties.length != defaultDirections.length || !this.verifyPriorities(defaultPriorities) || !this.verifyDirections(defaultDirections)) {
            this.priorities = new int[0];
            this.directions = new int[0];
            this.defaultPriorities = new int[0];
            this.defaultDirections = new int[0];
        } else {
            this.priorities = new int[defaultPriorities.length];
            System.arraycopy(defaultPriorities, 0, this.priorities, 0, this.priorities.length);
            this.directions = new int[defaultDirections.length];
            System.arraycopy(defaultDirections, 0, this.directions, 0, this.directions.length);
            this.defaultPriorities = new int[defaultPriorities.length];
            System.arraycopy(defaultPriorities, 0, this.defaultPriorities, 0, defaultPriorities.length);
            this.defaultDirections = new int[defaultDirections.length];
            System.arraycopy(defaultDirections, 0, this.defaultDirections, 0, defaultDirections.length);
        }
    }

    static TableComparator createTableSorter(IField[] sortingFields) {
        int[] defaultPriorities = new int[sortingFields.length];
        int i = 0;
        while (i < defaultPriorities.length) {
            defaultPriorities[i] = i;
            ++i;
        }
        int[] directions = new int[sortingFields.length];
        int i2 = 0;
        while (i2 < directions.length) {
            directions[i2] = sortingFields[i2].getDefaultDirection();
            ++i2;
        }
        return new TableComparator(sortingFields, defaultPriorities, directions);
    }

    protected void resetState() {
        System.arraycopy(this.defaultPriorities, 0, this.priorities, 0, this.priorities.length);
        System.arraycopy(this.defaultDirections, 0, this.directions, 0, this.directions.length);
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void setTopPriority(IField property) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(property)) {
                this.setTopPriority(i);
                return;
            }
            ++i;
        }
    }

    public void setTopPriority(int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.priorities.length) {
            if (this.priorities[i] == priority) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            this.resetState();
            return;
        }
        i = index;
        while (i > 0) {
            this.priorities[i] = this.priorities[i - 1];
            --i;
        }
        this.priorities[0] = priority;
        this.directions[priority] = this.defaultDirections[priority];
    }

    public void setTopPriorityDirection(int direction) {
        if (direction == 1 || direction == -1) {
            this.directions[this.priorities[0]] = direction;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public IField getTopField() {
        return this.fields[this.getTopPriority()];
    }

    public int[] getPriorities() {
        int[] copy = new int[this.priorities.length];
        System.arraycopy(this.priorities, 0, copy, 0, copy.length);
        return copy;
    }

    public int[] getDirections() {
        int[] copy = new int[this.directions.length];
        System.arraycopy(this.directions, 0, copy, 0, copy.length);
        return copy;
    }

    public int[] getDefaultPriorities() {
        int[] copy = new int[this.defaultPriorities.length];
        System.arraycopy(this.defaultPriorities, 0, copy, 0, copy.length);
        return copy;
    }

    public int[] getDefaultDirections() {
        int[] copy = new int[this.defaultDirections.length];
        System.arraycopy(this.defaultDirections, 0, copy, 0, copy.length);
        return copy;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2, 0, true);
    }

    protected int compare(Object obj1, Object obj2, int depth, boolean continueSearching) {
        if (depth >= this.priorities.length) {
            return 0;
        }
        int column = this.priorities[depth];
        IField property = this.fields[column];
        int result = property.compare(obj1, obj2);
        if (result == 0 && continueSearching) {
            return this.compare(obj1, obj2, depth + 1, continueSearching);
        }
        return result * this.directions[column];
    }

    public IField[] getFields() {
        return this.fields;
    }

    private boolean verifyPriorities(int[] priorities) {
        int length = priorities.length;
        boolean[] included = new boolean[length];
        Arrays.fill(included, false);
        int i = 0;
        while (i < length) {
            int priority = priorities[i];
            if (priority < 0 || priority >= length) {
                return false;
            }
            if (included[priority]) {
                return false;
            }
            included[priority] = true;
            ++i;
        }
        return true;
    }

    private boolean verifyDirections(int[] directions) {
        int[] nArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            int direction = nArray[n2];
            if (direction != 1 && direction != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int compare(Object o1, Object o2) {
        return this.compare(null, o1, o2);
    }

    public void saveState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            return;
        }
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = dialogSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        int i = 0;
        while (i < this.priorities.length) {
            settings.put(TAG_PRIORITY + i, this.priorities[i]);
            settings.put(TAG_DIRECTION + i, this.directions[i]);
            settings.put(TAG_DEFAULT_PRIORITY + i, this.defaultPriorities[i]);
            settings.put(TAG_DEFAULT_DIRECTION + i, this.defaultDirections[i]);
            ++i;
        }
    }

    public void restoreState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            this.resetState();
            return;
        }
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            this.resetState();
            return;
        }
        try {
            int i = 0;
            while (i < this.priorities.length) {
                String direction;
                String priority = settings.get(TAG_PRIORITY + i);
                if (priority == null) {
                    this.resetState();
                    return;
                }
                int fieldIndex = Integer.parseInt(priority);
                if (fieldIndex < this.fields.length) {
                    this.priorities[i] = fieldIndex;
                }
                if ((direction = settings.get(TAG_DIRECTION + i)) == null) {
                    this.resetState();
                    return;
                }
                this.directions[i] = Integer.parseInt(direction);
                String defaultPriority = settings.get(TAG_DEFAULT_PRIORITY + i);
                if (defaultPriority == null) {
                    this.resetState();
                    return;
                }
                this.defaultPriorities[i] = Integer.parseInt(defaultPriority);
                String defaultDirection = settings.get(TAG_DEFAULT_DIRECTION + i);
                if (defaultDirection == null) {
                    this.resetState();
                    return;
                }
                this.defaultDirections[i] = Integer.parseInt(defaultDirection);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.resetState();
        }
    }

    public void sort(TreeViewer viewer, MarkerList lastMarkers) {
        this.sort((Viewer)viewer, lastMarkers.getArray());
    }

    public void sort(final Viewer viewer, Object[] elements, int start, int end) {
        Arrays.sort(elements, start, end, new Comparator(){

            public int compare(Object a, Object b) {
                return TableComparator.this.compare(viewer, a, b);
            }
        });
    }
}

