/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.sphinx.pde.jobs.ConvertProjectToPluginProjectJob;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.internal.messages.Messages;

public class ConvertToXtendXpandEnabledPluginProjectJob
extends WorkspaceJob {
    public static final boolean HIDE_VERSION_1_7 = true;
    private static final String PROJECT_RELATIVE_JAVA_SOURCE_DEFAULT_PATH = "src";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_J2SE_1_5 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_6 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_7 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7";
    private static final String JAVA_EXTENSIONS_PACKAGE_DEFAULT_NAME = "extensions";
    private static final List<String> PDE_DEFAULT_REQUIRED_BUNDLES_IDS = Arrays.asList("org.eclipse.xtend.util.stdlib");
    private static final String PDE_EXECUTION_ENVIRONMENT_J2SE_15 = "J2SE-1.5";
    private static final String PDE_EXECUTION_ENVIRONMENT_JavaSE_16 = "JavaSE-1.6";
    private static final String PDE_EXECUTION_ENVIRONMENT_JavaSE_17 = "JavaSE-1.7";
    private IProject project;
    private String projectRelativeJavaSourcePath = "src";
    private String compilerCompliance;
    private String javaExtensionsPackageName;
    private List<String> requiredBundleIds = null;
    private List<String> enabledMetaModelContributorTypeNames = null;

    public ConvertToXtendXpandEnabledPluginProjectJob(String name, IProject project) {
        super(name);
        this.project = project;
        this.compilerCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        this.javaExtensionsPackageName = String.valueOf(project.getName().toLowerCase()) + "." + JAVA_EXTENSIONS_PACKAGE_DEFAULT_NAME;
        this.setPriority(40);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public String getProjectRelativeJavaSourcePath() {
        return this.projectRelativeJavaSourcePath;
    }

    public void setProjectRelativeJavaSourcePath(String projectRelativeJavaSourcePath) {
        this.projectRelativeJavaSourcePath = projectRelativeJavaSourcePath;
    }

    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    public void setCompilerCompliance(String compilerCompliance) {
        this.validateCompilerCompliance(compilerCompliance);
        this.compilerCompliance = compilerCompliance;
    }

    public String getJavaExtensionsPackageName() {
        return this.javaExtensionsPackageName;
    }

    public void setJavaExtensionsPackageName(String javaExtensionsPackageName) {
        this.javaExtensionsPackageName = javaExtensionsPackageName;
    }

    public List<String> getRequiredBundleIds() {
        if (this.requiredBundleIds == null) {
            this.requiredBundleIds = new ArrayList<String>(PDE_DEFAULT_REQUIRED_BUNDLES_IDS);
        }
        return this.requiredBundleIds;
    }

    public List<String> getEnabledMetamodelContributorTypeNames() {
        if (this.enabledMetaModelContributorTypeNames == null) {
            this.enabledMetaModelContributorTypeNames = new ArrayList<String>();
        }
        return this.enabledMetaModelContributorTypeNames;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToXtendXpandEnabledPluginProject, (int)5);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.convertToJavaProject((IProgressMonitor)progress.newChild(1));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.convertToPluginProject((IProgressMonitor)progress.newChild(1));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.convertToXtendXpandProject((IProgressMonitor)progress.newChild(1));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        return Status.OK_STATUS;
    }

    protected void convertToJavaProject(IProgressMonitor monitor) throws CoreException {
        IClasspathEntry classpathEntry;
        IPath javaSourcePath;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToJavaProject, (int)3);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.project.hasNature("org.eclipse.jdt.core.javanature")) {
            ExtendedPlatform.addNature((IProject)this.project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)progress.newChild(1));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        String projectRelativeJavaSourcePath = this.getProjectRelativeJavaSourcePath();
        if (projectRelativeJavaSourcePath != null && projectRelativeJavaSourcePath.length() > 0) {
            javaSourcePath = this.project.getFullPath().append(projectRelativeJavaSourcePath);
            IPath projectRelativeJavaSourcePathObj = javaSourcePath.removeFirstSegments(1);
            IFolder javaSourceFolder = this.project.getFolder(projectRelativeJavaSourcePathObj);
            if (!javaSourceFolder.exists()) {
                SubMonitor createSourceFolderProgress = progress.newChild(1).setWorkRemaining(javaSourcePath.segmentCount());
                int i = projectRelativeJavaSourcePathObj.segmentCount() - 1;
                while (i >= 0) {
                    IFolder folder = this.project.getFolder(projectRelativeJavaSourcePathObj.removeLastSegments(i));
                    if (!folder.exists()) {
                        folder.create(false, true, (IProgressMonitor)createSourceFolderProgress.newChild(1));
                    } else {
                        createSourceFolderProgress.worked(1);
                    }
                    --i;
                }
            }
        } else {
            javaSourcePath = this.project.getFullPath();
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        String compilerCompliance = this.getCompilerCompliance();
        if (compilerCompliance != null && !JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance").equals(compilerCompliance)) {
            javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", compilerCompliance);
            javaProject.setOption("org.eclipse.jdt.core.compiler.source", compilerCompliance);
            javaProject.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compilerCompliance);
        } else if (compilerCompliance == null) {
            compilerCompliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
        if (javaSourcePath.segmentCount() > 1) {
            IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSourcePath);
            Iterator iter = classpathEntries.iterator();
            while (iter.hasNext()) {
                classpathEntry = (IClasspathEntry)iter.next();
                if (!classpathEntry.getPath().isPrefixOf(javaSourcePath)) continue;
                iter.remove();
            }
            classpathEntries.add(0, sourceClasspathEntry);
        }
        IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
        Iterator i = classpathEntries.iterator();
        while (i.hasNext()) {
            classpathEntry = (IClasspathEntry)i.next();
            if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
            i.remove();
        }
        String jreContainer = JavaRuntime.JRE_CONTAINER;
        if ("1.5".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_J2SE_1_5;
        } else if ("1.6".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_6;
        } else if ("1.7".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_7;
        }
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(jreContainer)));
        IClasspathEntry[] entries = new IClasspathEntry[classpathEntries.size()];
        int i2 = 0;
        Iterator iterator = classpathEntries.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry;
            entries[i2] = entry = (IClasspathEntry)iterator.next();
            ++i2;
        }
        javaProject.setRawClasspath(entries, (IProgressMonitor)progress.newChild(1));
    }

    protected void convertToPluginProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToPluginProject, (int)2);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            ConvertProjectToPluginProjectJob convertProjectToPluginOperation = new ConvertProjectToPluginProjectJob(new IProject[]{this.project});
            convertProjectToPluginOperation.runInWorkspace((IProgressMonitor)progress.newChild(1));
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
            throw new CoreException(status);
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        StringBuilder requiredBundleIdsStr = new StringBuilder();
        Iterator<String> iter = this.getRequiredBundleIds().iterator();
        while (iter.hasNext()) {
            String id = iter.next();
            requiredBundleIdsStr.append(id);
            if (!iter.hasNext()) continue;
            requiredBundleIdsStr.append(",");
        }
        String requiredExecutionEnvironment = null;
        String compilerCompliance = this.getCompilerCompliance();
        if ("1.5".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_J2SE_15;
        } else if ("1.6".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_JavaSE_16;
        } else if ("1.7".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_JavaSE_17;
        }
        WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(PDEProject.getManifest((IProject)this.project), null);
        model.load();
        IBundle pluginBundle = model.getBundleModel().getBundle();
        pluginBundle.setHeader("Require-Bundle", requiredBundleIdsStr.toString());
        if (requiredExecutionEnvironment != null) {
            String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
            pluginBundle.setHeader(BUNDLE_REQUIREDEXECUTIONENVIRONMENT, requiredExecutionEnvironment);
        }
        model.save();
    }

    protected void convertToXtendXpandProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToXtendXpandProject, (int)3);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.project.hasNature("org.eclipse.xtend.shared.ui.xtendXPandNature")) {
            ExtendedPlatform.addNature((IProject)this.project, (String)"org.eclipse.xtend.shared.ui.xtendXPandNature", (IProgressMonitor)progress.newChild(1));
        }
        if (!this.getEnabledMetamodelContributorTypeNames().isEmpty()) {
            StringBuilder enabledMetaModelContributorTypeNamesStr = new StringBuilder();
            Iterator<String> iter = this.getEnabledMetamodelContributorTypeNames().iterator();
            while (iter.hasNext()) {
                String contributorTypeName = iter.next();
                enabledMetaModelContributorTypeNamesStr.append(contributorTypeName);
                if (!iter.hasNext()) continue;
                enabledMetaModelContributorTypeNamesStr.append(",");
            }
            IEclipsePreferences prefs = new ProjectScope(this.project).getNode("org.eclipse.xtend.shared.ui");
            prefs.put("project.specific.metamodel", Boolean.TRUE.toString());
            prefs.put("metamodelContributor", enabledMetaModelContributorTypeNamesStr.toString());
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
                throw new CoreException(status);
            }
        }
        progress.worked(1);
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IPackageFragmentRoot rootPackageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)this.project.getFolder(this.getProjectRelativeJavaSourcePath()));
        rootPackageFragmentRoot.createPackageFragment(this.getJavaExtensionsPackageName(), true, (IProgressMonitor)progress.newChild(1));
    }

    protected void validateCompilerCompliance(String compliance) {
        String compilerCompliance;
        Assert.isLegal((compliance.equals("1.6") || compliance.equals("1.5") ? 1 : 0) != 0, (String)NLS.bind((String)Messages.error_JRECompliance_NotSupported, (Object)"1.5", (Object)"1.6"));
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install instanceof IVMInstall2 && !(compilerCompliance = this.getCompilerCompliance((IVMInstall2)install, compliance)).equals(compliance)) {
            try {
                float complianceToSet = Float.parseFloat(compliance);
                float complianceFromVM = Float.parseFloat(compilerCompliance);
                Assert.isLegal((complianceToSet <= complianceFromVM ? 1 : 0) != 0, (String)NLS.bind((String)Messages.error_JRECompliance_NotCompatible, (Object)compliance, (Object)compilerCompliance));
            }
            catch (NumberFormatException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
    }

    protected String getCompilerCompliance(IVMInstall2 vMInstall, String defaultCompliance) {
        String version = vMInstall.getJavaVersion();
        if (version == null) {
            return defaultCompliance;
        }
        if (version.startsWith("1.7")) {
            return "1.6";
        }
        if (version.startsWith("1.6")) {
            return "1.6";
        }
        if (version.startsWith("1.5")) {
            return "1.5";
        }
        if (version.startsWith("1.4")) {
            return "1.4";
        }
        if (version.startsWith("1.3")) {
            return "1.3";
        }
        if (version.startsWith("1.2")) {
            return "1.3";
        }
        if (version.startsWith("1.1")) {
            return "1.3";
        }
        return defaultCompliance;
    }
}

