/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.ui.views.AbstractField;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FieldLineNumber
extends AbstractField {
    private String description = MarkerMessages.description_lineNumber;
    private Image image;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Image getDescriptionImage() {
        return this.image;
    }

    @Override
    public String getColumnHeaderText() {
        return this.description;
    }

    @Override
    public Image getColumnHeaderImage() {
        return this.image;
    }

    @Override
    public String getValue(Object obj) {
        if (obj == null) {
            return MarkerMessages.FieldMessage_NullMessage;
        }
        if (obj instanceof MarkerNode) {
            MarkerNode node = (MarkerNode)obj;
            if (node.isConcrete()) {
                ConcreteMarker concreteNode = (ConcreteMarker)node;
                if (concreteNode.getLocationString().length() == 0) {
                    if (concreteNode.getLine() < 0) {
                        return MarkerMessages.Unknown;
                    }
                    return NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(concreteNode.getLine()));
                }
                return concreteNode.getLocationString();
            }
            return Util.EMPTY_STRING;
        }
        if (obj instanceof IWorkbenchAdapter) {
            return Util.EMPTY_STRING;
        }
        if (obj instanceof IMarker) {
            return Util.getProperty("lineNumber", (IMarker)obj);
        }
        return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)obj.toString());
    }

    @Override
    public Image getImage(Object obj) {
        return null;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null || !(obj1 instanceof ConcreteMarker) || !(obj2 instanceof ConcreteMarker)) {
            return 0;
        }
        ConcreteMarker marker1 = (ConcreteMarker)obj1;
        ConcreteMarker marker2 = (ConcreteMarker)obj2;
        String location1 = marker1.getLocationString();
        String location2 = marker2.getLocationString();
        if (location1.length() == 0 || location2.length() == 0) {
            return marker1.getLine() - marker2.getLine();
        }
        return location1.compareTo(location2);
    }

    @Override
    public int getDefaultDirection() {
        return 1;
    }

    @Override
    public int getPreferredWidth() {
        return 60;
    }
}

