/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSelectionProviderAction;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class ActionRemoveMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;
    private String markerName;

    public ActionRemoveMarker(IWorkbenchPart part, ISelectionProvider provider, String markerName) {
        super(provider, MarkerMessages.deleteAction_title);
        this.part = part;
        this.markerName = markerName;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setToolTipText(MarkerMessages.deleteAction_tooltip);
        this.setEnabled(false);
    }

    public void run() {
        String operationTitle = NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object)MarkerMessages.deleteAction_title, (Object)this.markerName);
        DeleteMarkersOperation op = new DeleteMarkersOperation(this.getSelectedMarkers(), operationTitle);
        this.execute((IUndoableOperation)op, MarkerMessages.RemoveMarker_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.part.getSite().getShell()));
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object obj : selection) {
            if (!(obj instanceof ConcreteMarker)) {
                return;
            }
            if (Util.isEditable(((ConcreteMarker)obj).getMarker())) continue;
            return;
        }
        this.setEnabled(true);
    }
}

