/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class ConstraintExtensionUtil {
    private static ConstraintRegistry constraintRegistry = ConstraintRegistry.getInstance();

    public static XmlConstraintDescriptor getXmlConstraintDescriptor(String ruleId) {
        Assert.isNotNull((Object)ruleId);
        IConstraintDescriptor icd = constraintRegistry.getDescriptor(ruleId);
        return icd != null && icd instanceof XmlConstraintDescriptor ? (XmlConstraintDescriptor)icd : null;
    }

    public static Map<String, Set<String>> getRulesFeatures(String ruleId) {
        Assert.isNotNull((Object)ruleId);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        XmlConstraintDescriptor xcd = ConstraintExtensionUtil.getXmlConstraintDescriptor(ruleId);
        if (xcd != null) {
            IConfigurationElement[] targets;
            IConfigurationElement[] iConfigurationElementArray = targets = xcd.getConfig().getChildren("target");
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ice_target = iConfigurationElementArray[n2];
                String tgt = ice_target.getAttribute("class");
                HashSet<String> features = new HashSet<String>();
                IConfigurationElement[] iConfigurationElementArray2 = ice_target.getChildren("event");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ice_event = iConfigurationElementArray2[n4];
                    IConfigurationElement[] iConfigurationElementArray3 = ice_event.getChildren("feature");
                    int n5 = iConfigurationElementArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement ice_feature = iConfigurationElementArray3[n6];
                        features.add(ice_feature.getAttribute("name"));
                        ++n6;
                    }
                    ++n4;
                }
                result.put(tgt, features);
                ++n2;
            }
        }
        return result;
    }

    public static Set<String> getParamOfType(String ruleId, String parameterID) {
        Assert.isNotNull((Object)ruleId);
        HashSet<String> result = new HashSet<String>();
        XmlConstraintDescriptor xcd = ConstraintExtensionUtil.getXmlConstraintDescriptor(ruleId);
        if (xcd != null) {
            IConfigurationElement[] targets = xcd.getConfig().getChildren("param");
            String value = null;
            IConfigurationElement[] iConfigurationElementArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement target = iConfigurationElementArray[n2];
                if (target.getAttribute("name").equals(parameterID) && (value = target.getAttribute("value")) != null && value.length() > 0) {
                    result.add(value);
                }
                ++n2;
            }
        }
        return result;
    }
}

