/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.binding.wemo.handler.WemoBridgeHandler;
import org.eclipse.smarthome.binding.wemo.handler.WemoCoffeeHandler;
import org.eclipse.smarthome.binding.wemo.handler.WemoHandler;
import org.eclipse.smarthome.binding.wemo.handler.WemoLightHandler;
import org.eclipse.smarthome.binding.wemo.handler.WemoMakerHandler;
import org.eclipse.smarthome.binding.wemo.internal.discovery.WemoLinkDiscoveryService;
import org.eclipse.smarthome.binding.wemo.internal.http.WemoHttpCall;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.wemo")
public class WemoHandlerFactory
extends BaseThingHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(WemoHandlerFactory.class);
    private UpnpIOService upnpIOService;
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = WemoBindingConstants.SUPPORTED_THING_TYPES;
    private final Map<ThingUID, ServiceRegistration<?>> discoveryServiceRegs = new HashMap();

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID != null) {
            this.logger.debug("Trying to create a handler for ThingType '{}", (Object)thingTypeUID);
            WemoHttpCall wemoHttpcaller = new WemoHttpCall();
            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_BRIDGE)) {
                this.logger.debug("Creating a WemoBridgeHandler for thing '{}' with UDN '{}'", (Object)thing.getUID(), thing.getConfiguration().get("udn"));
                WemoBridgeHandler handler = new WemoBridgeHandler((Bridge)thing);
                this.registerDeviceDiscoveryService(handler, wemoHttpcaller);
                return handler;
            }
            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_MAKER)) {
                this.logger.debug("Creating a WemoMakerHandler for thing '{}' with UDN '{}'", (Object)thing.getUID(), thing.getConfiguration().get("udn"));
                return new WemoMakerHandler(thing, this.upnpIOService, wemoHttpcaller);
            }
            if (WemoBindingConstants.SUPPORTED_DEVICE_THING_TYPES.contains(thing.getThingTypeUID())) {
                this.logger.debug("Creating a WemoHandler for thing '{}' with UDN '{}'", (Object)thing.getUID(), thing.getConfiguration().get("udn"));
                return new WemoHandler(thing, this.upnpIOService, wemoHttpcaller);
            }
            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_COFFEE)) {
                this.logger.debug("Creating a WemoCoffeeHandler for thing '{}' with UDN '{}'", (Object)thing.getUID(), thing.getConfiguration().get("udn"));
                return new WemoCoffeeHandler(thing, this.upnpIOService, wemoHttpcaller);
            }
            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_MZ100)) {
                return new WemoLightHandler(thing, this.upnpIOService, wemoHttpcaller);
            }
            this.logger.warn("ThingHandler not found for {}", (Object)thingTypeUID);
            return null;
        }
        return null;
    }

    @Reference
    protected void setUpnpIOService(UpnpIOService upnpIOService) {
        this.upnpIOService = upnpIOService;
    }

    protected void unsetUpnpIOService(UpnpIOService upnpIOService) {
        this.upnpIOService = null;
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof WemoBridgeHandler && (serviceReg = this.discoveryServiceRegs.remove(thingHandler.getThing().getUID())) != null) {
            serviceReg.unregister();
        }
    }

    private synchronized void registerDeviceDiscoveryService(WemoBridgeHandler wemoBridgeHandler, WemoHttpCall wemoHttpCaller) {
        WemoLinkDiscoveryService discoveryService = new WemoLinkDiscoveryService(wemoBridgeHandler, this.upnpIOService, wemoHttpCaller);
        this.discoveryServiceRegs.put(wemoBridgeHandler.getThing().getUID(), this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable()));
    }
}

