/**
 * generated by Xtext
 */
package org.eclipse.smarthome.model.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapPackage;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.model.validation.AbstractSitemapValidator;
import org.eclipse.xtext.validation.Check;

/**
 * Custom validation rules.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
@SuppressWarnings("all")
public class SitemapValidator extends AbstractSitemapValidator {
  @Check
  public void checkFramesInFrame(final Frame frame) {
    EList<Widget> _children = frame.getChildren();
    for (final Widget w : _children) {
      if ((w instanceof Frame)) {
        EStructuralFeature _eStructuralFeature = SitemapPackage.Literals.FRAME.getEStructuralFeature(SitemapPackage.FRAME__CHILDREN);
        this.error("Frames must not contain other frames", _eStructuralFeature);
        return;
      }
    }
  }
  
  @Check
  public void checkFramesInWidgetList(final Sitemap sitemap) {
    boolean containsFrames = false;
    boolean containsOtherWidgets = false;
    EList<Widget> _children = sitemap.getChildren();
    for (final Widget w : _children) {
      {
        if ((w instanceof Frame)) {
          containsFrames = true;
        } else {
          containsOtherWidgets = true;
        }
        if ((containsFrames && containsOtherWidgets)) {
          EStructuralFeature _eStructuralFeature = SitemapPackage.Literals.FRAME.getEStructuralFeature(SitemapPackage.SITEMAP__CHILDREN);
          this.error("Sitemap should contain either only frames or none at all", _eStructuralFeature);
          return;
        }
      }
    }
  }
  
  @Check
  public void checkFramesInWidgetList(final LinkableWidget widget) {
    if ((widget instanceof Frame)) {
      return;
    }
    boolean containsFrames = false;
    boolean containsOtherWidgets = false;
    EList<Widget> _children = widget.getChildren();
    for (final Widget w : _children) {
      {
        if ((w instanceof Frame)) {
          containsFrames = true;
        } else {
          containsOtherWidgets = true;
        }
        if ((containsFrames && containsOtherWidgets)) {
          EStructuralFeature _eStructuralFeature = SitemapPackage.Literals.FRAME.getEStructuralFeature(SitemapPackage.LINKABLE_WIDGET__CHILDREN);
          this.error("Linkable widget should contain either only frames or none at all", _eStructuralFeature);
          return;
        }
      }
    }
  }
}
