/**
 * Copyright (c) 2014,2018 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;

/**
 * The {@link DS2401} class defines an DS2401 (iButton) device
 *
 * @author Jan N. Klug - Initial contribution
 */
@NonNullByDefault
public class DS2401 extends AbstractOwDevice {

    public DS2401(String sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
        isConfigured = true;
    }

    @Override
    public void configureChannels() throws OwException {
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
    }
}
