/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.actions;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.eclipse.smarthome.model.script.engine.action.ActionDoc;
import org.eclipse.smarthome.model.script.engine.action.ParamDoc;
import org.eclipse.smarthome.model.script.internal.engine.action.VoiceActionService;

public class Voice {
    @ActionDoc(text="says a given text with the default voice")
    public static void say(@ParamDoc(name="text") Object text) {
        Voice.say(text, null);
    }

    @ActionDoc(text="says a given text with a given voice")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") String voice) {
        Voice.say(text, voice, null);
    }

    @ActionDoc(text="says a given text with a given voice through the given sink")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") String voice, @ParamDoc(name="sink") String sink) {
        if (StringUtils.isNotBlank((String)text.toString())) {
            VoiceActionService.voiceManager.say(text.toString(), voice, sink);
        }
    }

    @ActionDoc(text="interprets a given text by the default human language interpreter", returns="human language response")
    public static String interpret(@ParamDoc(name="text") Object text) {
        return Voice.interpret(text, null);
    }

    @ActionDoc(text="interprets a given text by a given human language interpreter", returns="human language response")
    public static String interpret(@ParamDoc(name="text") Object text, @ParamDoc(name="interpreter") String interpreter) {
        String response;
        try {
            response = VoiceActionService.voiceManager.interpret(text.toString(), interpreter);
        }
        catch (InterpretationException e) {
            Voice.say(e.getMessage());
            response = e.getMessage();
        }
        return response;
    }

    @ActionDoc(text="interprets a given text by a given human language interpreter", returns="human language response")
    public static String interpret(@ParamDoc(name="text") Object text, @ParamDoc(name="interpreter") String interpreter, @ParamDoc(name="sink") String sink) {
        String response;
        try {
            response = VoiceActionService.voiceManager.interpret(text.toString(), interpreter);
        }
        catch (InterpretationException e) {
            if (sink != null) {
                Voice.say(e.getMessage(), null, sink);
            }
            response = e.getMessage();
        }
        return response;
    }
}

