/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.actions;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static Logger logger = LoggerFactory.getLogger(HTTP.class);

    public static String sendHttpGetRequest(String url) {
        return HTTP.sendHttpGetRequest(url, 5000);
    }

    public static String sendHttpGetRequest(String url, int timeout) {
        String response = null;
        try {
            return HttpUtil.executeUrl((String)"GET", (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return response;
        }
    }

    public static String sendHttpPutRequest(String url) {
        return HTTP.sendHttpPutRequest(url, 1000);
    }

    public static String sendHttpPutRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)"PUT", (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPutRequest(String url, String contentType, String content) {
        return HTTP.sendHttpPutRequest(url, contentType, content, 1000);
    }

    public static String sendHttpPutRequest(String url, String contentType, String content, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)"PUT", (String)url, (InputStream)IOUtils.toInputStream((String)content), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPostRequest(String url) {
        return HTTP.sendHttpPostRequest(url, 1000);
    }

    public static String sendHttpPostRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)"POST", (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPostRequest(String url, String contentType, String content) {
        return HTTP.sendHttpPostRequest(url, contentType, content, 1000);
    }

    public static String sendHttpPostRequest(String url, String contentType, String content, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)"POST", (String)url, (InputStream)IOUtils.toInputStream((String)content), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpDeleteRequest(String url) {
        return HTTP.sendHttpDeleteRequest(url, 1000);
    }

    public static String sendHttpDeleteRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)"DELETE", (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }
}

