/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.auth.basic.internal;

import java.util.StringTokenizer;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.smarthome.core.auth.Credentials;
import org.eclipse.smarthome.core.auth.UsernamePasswordCredentials;
import org.eclipse.smarthome.io.rest.auth.AbstractSecurityHandler;

public class BasicSecurityHandler
extends AbstractSecurityHandler {
    protected Credentials createCredentials(ContainerRequestContext requestContext) {
        String authenticationHeader = requestContext.getHeaderString("Authorization");
        if (authenticationHeader == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(authenticationHeader, " ");
        String authType = tokenizer.nextToken();
        if ("BASIC".equalsIgnoreCase(authType)) {
            String usernameAndPassword = new String(Base64.decodeBase64((String)tokenizer.nextToken()));
            tokenizer = new StringTokenizer(usernameAndPassword, ":");
            String username = tokenizer.nextToken();
            String password = tokenizer.nextToken();
            return new UsernamePasswordCredentials(username, password);
        }
        return null;
    }

    public String getAuthenticationScheme() {
        return "BASIC";
    }
}

