/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.pdf.utils;

import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.browser.DownloadListener;
import org.eclipse.set.core.services.pdf.PdfViewer;
import org.eclipse.set.utils.FileWebBrowser;
import org.eclipse.swt.widgets.Composite;

public class BrowserPdfViewer
implements PdfViewer,
DownloadListener {
    private static final String PDF_VIEWER_PATH = "./web/pdf";
    private static final String PDF_FILE_PATH_PREFIX = "pdffile/";
    private static final String HTML_PDF_VIEWER_PATH = "viewer.html";
    private FileWebBrowser browser;
    private PdfViewer.SaveListener saveListener;
    private final Composite parent;

    public BrowserPdfViewer(Composite parent) {
        this.parent = parent;
    }

    public void refresh() {
        this.browser.refresh();
    }

    public void show(Path path) {
        try {
            if (this.browser == null) {
                this.browser = new FileWebBrowser(this.parent);
                this.browser.getBrowser().setDownloadListener((DownloadListener)this);
                this.browser.serveRootDirectory(Path.of(PDF_VIEWER_PATH, new String[0]));
                GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo(this.browser.getControl());
            }
            String serverPath = PDF_FILE_PATH_PREFIX + path.getFileName().toString();
            this.browser.serveFile(serverPath, "application/pdf", path);
            String viewerUrl = "https://toolbox/viewer.html?file=/" + serverPath;
            this.browser.setUrl(viewerUrl);
        }
        catch (Exception e) {
            throw new RuntimeException("Fehler beim Anzeigen der PDF-Datei.", e);
        }
    }

    public Optional<Path> beforeDownload(String suggestedName, String url) {
        if (this.saveListener != null) {
            return this.saveListener.saveFile(suggestedName);
        }
        return Optional.empty();
    }

    public void downloadFinished(boolean success, Path path) {
        if (this.saveListener != null) {
            this.saveListener.saveCompleted(path);
        }
    }

    public void setSaveListener(PdfViewer.SaveListener saveListener) {
        this.saveListener = saveListener;
    }
}

