/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.util.function.Consumer;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.LeftRight;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.TrackLock;
import org.eclipse.set.model.siteplan.TrackLockComponent;
import org.eclipse.set.model.siteplan.TrackLockLocation;
import org.eclipse.set.model.siteplan.TurnoutOperatingMode;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Auswurfrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMGleissperreVorzugslage;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMGleissperrensignal;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.ENUMWKrGspStellart;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Entgleisungsschuh_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperre_Vorzugslage_TypeClass;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Gleissperrensignal_TypeClass;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Stellart_TypeClass;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class TrackLockTransformator
extends BaseTransformator<W_Kr_Gsp_Element> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;
    private static String lockBothSide = "beidseitig";
    private static String lockOneSide = "einseitig";

    @Override
    public void transform(W_Kr_Gsp_Element gspElement) {
        boolean _tripleEquals;
        Gleissperre_Element_AttributeGroup _gleissperreElement = gspElement.getGleissperreElement();
        Gleissperre_Vorzugslage_TypeClass _gleissperreVorzugslage = null;
        if (_gleissperreElement != null) {
            _gleissperreVorzugslage = _gleissperreElement.getGleissperreVorzugslage();
        }
        boolean bl = _tripleEquals = _gleissperreVorzugslage == null;
        if (_tripleEquals) {
            return;
        }
        final TrackLock result = SiteplanFactory.eINSTANCE.createTrackLock();
        result.setGuid(gspElement.getIdentitaet().getWert());
        result.setLabel(TransformUtils.getLabel(gspElement.getBezeichnung()));
        result.setPreferredLocation(this.transformLocation(gspElement));
        result.setOperatingMode(this.transformOperatingMode(gspElement));
        Consumer<W_Kr_Gsp_Komponente> _function = new Consumer<W_Kr_Gsp_Komponente>(){

            @Override
            public void accept(W_Kr_Gsp_Komponente it) {
                TrackLockComponent component = SiteplanFactory.eINSTANCE.createTrackLockComponent();
                component.setGuid(it.getIdentitaet().getWert());
                component.setPosition(TrackLockTransformator.this.positionService.transformPosition(TrackLockTransformator.this.trackService.getCoordinate((Punkt_Objekt)it)));
                component.setTrackLockSignal(TrackLockTransformator.this.transformTrackLockSignal(it));
                component.setEjectionDirection(TrackLockTransformator.this.transformEjectionDirection(it));
                result.getComponents().add((Object)component);
            }
        };
        WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement).forEach(_function);
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_TrackLock());
    }

    private LeftRight transformEjectionDirection(W_Kr_Gsp_Komponente komponente) {
        ENUMLinksRechts direction;
        Entgleisungsschuh_AttributeGroup _entgleisungsschuh = komponente.getEntgleisungsschuh();
        Auswurfrichtung_TypeClass _auswurfrichtung = null;
        if (_entgleisungsschuh != null) {
            _auswurfrichtung = _entgleisungsschuh.getAuswurfrichtung();
        }
        ENUMLinksRechts _wert = null;
        if (_auswurfrichtung != null) {
            _wert = _auswurfrichtung.getWert();
        }
        if ((direction = _wert) != null) {
            switch (direction) {
                case ENUM_LINKS_RECHTS_LINKS: {
                    return LeftRight.LEFT;
                }
                case ENUM_LINKS_RECHTS_RECHTS: {
                    return LeftRight.RIGHT;
                }
            }
            return null;
        }
        return null;
    }

    private String transformTrackLockSignal(W_Kr_Gsp_Komponente komponente) {
        ENUMGleissperrensignal lockSignal;
        Entgleisungsschuh_AttributeGroup _entgleisungsschuh = null;
        if (komponente != null) {
            _entgleisungsschuh = komponente.getEntgleisungsschuh();
        }
        Gleissperrensignal_TypeClass _gleissperrensignal = null;
        if (_entgleisungsschuh != null) {
            _gleissperrensignal = _entgleisungsschuh.getGleissperrensignal();
        }
        ENUMGleissperrensignal _wert = null;
        if (_gleissperrensignal != null) {
            _wert = _gleissperrensignal.getWert();
        }
        if ((lockSignal = _wert) == null) {
            return null;
        }
        if (lockSignal != null) {
            switch (lockSignal) {
                case ENUM_GLEISSPERRENSIGNAL_INNENBELEUCHTET_BEIDSEITIG: 
                case ENUM_GLEISSPERRENSIGNAL_REFLEKTIEREND_BEIDSEITIG: {
                    return lockBothSide;
                }
                case ENUM_GLEISSPERRENSIGNAL_INNENBELEUCHTET_EINSEITIG: 
                case ENUM_GLEISSPERRENSIGNAL_REFLEKTIEREND_EINSEITIG: {
                    return lockOneSide;
                }
            }
            return "";
        }
        return "";
    }

    private TrackLockLocation transformLocation(W_Kr_Gsp_Element gspElement) {
        ENUMGleissperreVorzugslage location;
        Gleissperre_Element_AttributeGroup _gleissperreElement = gspElement.getGleissperreElement();
        Gleissperre_Vorzugslage_TypeClass _gleissperreVorzugslage = null;
        if (_gleissperreElement != null) {
            _gleissperreVorzugslage = _gleissperreElement.getGleissperreVorzugslage();
        }
        ENUMGleissperreVorzugslage _wert = null;
        if (_gleissperreVorzugslage != null) {
            _wert = _gleissperreVorzugslage.getWert();
        }
        if ((location = _wert) == null) {
            return null;
        }
        if (location != null) {
            switch (location) {
                case ENUM_GLEISSPERRE_VORZUGSLAGE_ABGELEGT: {
                    return TrackLockLocation.BESIDE_TRACK;
                }
                case ENUM_GLEISSPERRE_VORZUGSLAGE_AUFGELEGT: {
                    return TrackLockLocation.ON_TRACK;
                }
            }
            return null;
        }
        return null;
    }

    private TurnoutOperatingMode transformOperatingMode(W_Kr_Gsp_Element gspElement) {
        ENUMWKrGspStellart operatingMode;
        W_Kr_Gsp_Element_Allg_AttributeGroup _wKrGspElementAllg = gspElement.getWKrGspElementAllg();
        W_Kr_Gsp_Stellart_TypeClass _wKrGspStellart = null;
        if (_wKrGspElementAllg != null) {
            _wKrGspStellart = _wKrGspElementAllg.getWKrGspStellart();
        }
        ENUMWKrGspStellart _wert = null;
        if (_wKrGspStellart != null) {
            _wert = _wKrGspStellart.getWert();
        }
        if ((operatingMode = _wert) == null) {
            return null;
        }
        if (operatingMode != null) {
            switch (operatingMode) {
                case ENUMW_KR_GSP_STELLART_ELEKTRISCH_FERNGESTELLT: 
                case ENUMW_KR_GSP_STELLART_MECHANISCH_FERNGESTELLT: {
                    return TurnoutOperatingMode.MECHANICAL_REMOTE;
                }
                case ENUMW_KR_GSP_STELLART_ELEKTRISCH_ORTSGESTELLT: 
                case ENUMW_KR_GSP_STELLART_MECHANISCH_ORTSGESTELLT: {
                    return TurnoutOperatingMode.MECHANICAL_LOCAL;
                }
            }
            return null;
        }
        return null;
    }
}

