/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteMetadata;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteSegment;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.SignalInfo;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.Direction;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.RouteObject;
import org.eclipse.set.model.siteplan.Signal;
import org.eclipse.set.model.siteplan.SignalMount;
import org.eclipse.set.model.siteplan.SignalMountType;
import org.eclipse.set.model.siteplan.SignalRole;
import org.eclipse.set.model.siteplan.SignalScreen;
import org.eclipse.set.model.siteplan.SignalSystem;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalBefestigungExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Seitliche_Lage_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Seitlicher_Abstand_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Gleis.ENUMGleisart;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Art;
import org.eclipse.set.toolboxmodel.Gleis.Gleisart_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.ENUMBefestigungArt;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalArt;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalBefestigungsart;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalsystem;
import org.eclipse.set.toolboxmodel.Signale.Geschaltet_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Befestigung;
import org.eclipse.set.toolboxmodel.Signale.Signal_Befestigungsart_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Rahmen;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signalsystem_TypeClass;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class SignalTransformator
extends BaseTransformator<org.eclipse.set.toolboxmodel.Signale.Signal> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;
    private static final String ERROR_NO_LATERAL_POSITION = "Seitliche Positionierung des Signals '%s' nicht bestimmbar.";
    private static final String ERROR_FAILED_TRANSFORM = "Fehler bei der Signaltransformation.";
    private static final List<String> SITEPLAN_HIDDEN_SCREENS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"Ra12", "Ts1", "Ts2", "Ts3", "Zp6", "Zp7", "Zp8", "El1", "El1v", "El2", "El3", "El4", "El5", "El6", "Ra13", "Wn7", "OzZf", "OzICE", "OzFak", "OzZugl", "Ne7a", "Ne7b", "Bue4", "Bue5", "OzAutoHET", "OzHET", "OzAutoET", "OzET"}));
    private static final double PUNKT_OBJEKT_LATERAL_DISTANCE_IN_STATION = 2.25;
    private static final double PUNKT_OBJEKT_LATERAL_DISTANCE_OTHER = 3.5;
    private List<SignalInfo> signalinfo;

    @Override
    public void initializeTransform() {
        ArrayList<SignalInfo> _arrayList = new ArrayList<SignalInfo>();
        this.signalinfo = _arrayList;
    }

    @Override
    public void transform(org.eclipse.set.toolboxmodel.Signale.Signal signal) {
        SignalInfo si = new SignalInfo();
        si.signals = IterableExtensions.toSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new org.eclipse.set.toolboxmodel.Signale.Signal[]{signal})));
        Set _elvis = null;
        List _signalRahmen = SignalExtensions.signalRahmen((org.eclipse.set.toolboxmodel.Signale.Signal)signal);
        List _map = null;
        if (_signalRahmen != null) {
            Functions.Function1<Signal_Rahmen, Signal_Befestigung> _function = new Functions.Function1<Signal_Rahmen, Signal_Befestigung>(){

                public Signal_Befestigung apply(Signal_Rahmen it) {
                    return SignalRahmenExtensions.getSignalBefestigung((Signal_Rahmen)it);
                }
            };
            _map = ListExtensions.map((List)_signalRahmen, (Functions.Function1)_function);
        }
        Set _set = null;
        if (_map != null) {
            _set = IterableExtensions.toSet(_map);
        }
        if (_set != null) {
            _elvis = _set;
        } else {
            HashSet _newHashSet = CollectionLiterals.newHashSet();
            _elvis = _newHashSet;
        }
        si.mounts = _elvis;
        this.signalinfo.add(si);
    }

    @Override
    public void finalizeTransform() {
        final ArrayList mergedSignalInfo = new ArrayList();
        Consumer<SignalInfo> _function = new Consumer<SignalInfo>(){

            @Override
            public void accept(SignalInfo si) {
                try {
                    Functions.Function1<Signal_Befestigung, List<Signal_Befestigung>> _function = new Functions.Function1<Signal_Befestigung, List<Signal_Befestigung>>(){

                        public List<Signal_Befestigung> apply(Signal_Befestigung mount) {
                            List _signalBefestigungen = null;
                            if (mount != null) {
                                _signalBefestigungen = SignalBefestigungExtensions.getSignalBefestigungen((Signal_Befestigung)mount);
                            }
                            return _signalBefestigungen;
                        }
                    };
                    final Iterable signalMounts = Iterables.concat((Iterable)IterableExtensions.map(si.mounts, (Functions.Function1)_function));
                    Functions.Function1<SignalInfo, Boolean> _function_1 = new Functions.Function1<SignalInfo, Boolean>(){

                        public Boolean apply(SignalInfo msi) {
                            return msi.mounts.contains(IterableExtensions.last((Iterable)signalMounts));
                        }
                    };
                    SignalInfo merged = (SignalInfo)IterableExtensions.findFirst((Iterable)mergedSignalInfo, (Functions.Function1)_function_1);
                    if (merged == null) {
                        HashSet<Signal_Befestigung> mounts = new HashSet<Signal_Befestigung>();
                        Iterables.addAll(mounts, si.mounts);
                        Iterables.addAll(mounts, (Iterable)signalMounts);
                        si.mounts = mounts;
                        mergedSignalInfo.add(si);
                    } else {
                        Iterables.addAll(merged.signals, si.signals);
                        Iterables.addAll(merged.mounts, (Iterable)signalMounts);
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        org.eclipse.set.toolboxmodel.Signale.Signal _head = (org.eclipse.set.toolboxmodel.Signale.Signal)IterableExtensions.head(si.signals);
                        Identitaet_TypeClass _identitaet = null;
                        if (_head != null) {
                            _identitaet = _head.getIdentitaet();
                        }
                        String _wert = null;
                        if (_identitaet != null) {
                            _wert = _identitaet.getWert();
                        }
                        SignalTransformator.this.recordError(_wert, SignalTransformator.ERROR_FAILED_TRANSFORM);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        this.signalinfo.forEach(_function);
        Functions.Function1<SignalInfo, Boolean> _function_1 = new Functions.Function1<SignalInfo, Boolean>(){

            public Boolean apply(SignalInfo it) {
                int _length = ((Object[])Conversions.unwrapArray(it.signals, Object.class)).length;
                return _length != 0;
            }
        };
        Iterable signals = IterableExtensions.filter(mergedSignalInfo, (Functions.Function1)_function_1);
        Consumer<SignalInfo> _function_2 = new Consumer<SignalInfo>(){

            @Override
            public void accept(SignalInfo it) {
                try {
                    SignalMount signal = SignalTransformator.this.transform(it);
                    if (signal != null) {
                        SignalTransformator.this.addSiteplanElement(signal, SiteplanPackage.eINSTANCE.getSiteplanState_Signals());
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        org.eclipse.set.toolboxmodel.Signale.Signal _head = (org.eclipse.set.toolboxmodel.Signale.Signal)IterableExtensions.head(it.signals);
                        Identitaet_TypeClass _identitaet = null;
                        if (_head != null) {
                            _identitaet = _head.getIdentitaet();
                        }
                        String _wert = null;
                        if (_identitaet != null) {
                            _wert = _identitaet.getWert();
                        }
                        SignalTransformator.this.recordError(_wert, SignalTransformator.ERROR_FAILED_TRANSFORM);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        signals.forEach(_function_2);
    }

    public SignalMount transform(final SignalInfo signalInfo) {
        boolean _tripleNotEquals;
        GEOKanteCoordinate point = this.getSignalObjectCoordinate((Punkt_Objekt)signalInfo.getFirstSignal());
        double effectiveRotation = point.getEffectiveRotation();
        Signal_Befestigung _baseMount = signalInfo.getBaseMount();
        boolean bl = _tripleNotEquals = _baseMount != null;
        if (_tripleNotEquals) {
            point = this.getSignalObjectCoordinate((Punkt_Objekt)signalInfo.getBaseMount());
        }
        final SignalMount signalMount = SiteplanFactory.eINSTANCE.createSignalMount();
        signalMount.setGuid(signalInfo.getSignalGuid());
        signalMount.setPosition(this.positionService.transformPosition(point));
        Position _position = signalMount.getPosition();
        _position.setRotation(effectiveRotation);
        signalMount.setMountType(this.getMountType(signalInfo));
        Functions.Function1<org.eclipse.set.toolboxmodel.Signale.Signal, Signal> _function = new Functions.Function1<org.eclipse.set.toolboxmodel.Signale.Signal, Signal>(){

            public Signal apply(org.eclipse.set.toolboxmodel.Signale.Signal it) {
                return SignalTransformator.this.transformAttachedSignal(it, signalInfo, signalMount);
            }
        };
        Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isEmpty = it.getScreen().isEmpty();
                return !_isEmpty;
            }
        };
        Iterables.addAll((Collection)signalMount.getAttachedSignals(), (Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(signalInfo.signals, (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isEmpty = signalMount.getAttachedSignals().isEmpty();
        if (_isEmpty) {
            return null;
        }
        return signalMount;
    }

    private Signal transformAttachedSignal(org.eclipse.set.toolboxmodel.Signale.Signal ppsignal, SignalInfo signalInfo, SignalMount signalMount) {
        Signal it = SiteplanFactory.eINSTANCE.createSignal();
        it.setGuid(ppsignal.getIdentitaet().getWert());
        Bezeichnung_Element_AttributeGroup _bezeichnung = ppsignal.getBezeichnung();
        Label _label = null;
        if (_bezeichnung != null) {
            _label = TransformUtils.getLabel(_bezeichnung);
        }
        it.setLabel(_label);
        it.setRole(SignalTransformator.getSignalRole(ppsignal));
        it.setSystem(SignalTransformator.getSignalSystem(ppsignal));
        it.setSignalDirection(this.transformSignalDirection(ppsignal));
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, BigDecimal> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, BigDecimal>(){

            public BigDecimal apply(Punkt_Objekt_TOP_Kante_AttributeGroup it_1) {
                Seitlicher_Abstand_TypeClass _seitlicherAbstand = it_1.getSeitlicherAbstand();
                BigDecimal _wert = null;
                if (_seitlicherAbstand != null) {
                    _wert = _seitlicherAbstand.getWert();
                }
                return _wert;
            }
        };
        it.getLateralDistance().addAll((Collection)ListExtensions.map((List)ppsignal.getPunktObjektTOPKante(), (Functions.Function1)_function));
        TransformUtils.transformPunktObjektStrecke((Punkt_Objekt)ppsignal, (RouteObject)it);
        GEOKanteCoordinate coordinate = this.getSignalObjectCoordinate((Punkt_Objekt)ppsignal);
        it.setMountPosition(this.positionService.transformPosition(coordinate));
        EList _screen = it.getScreen();
        Functions.Function1<SignalScreen, Boolean> _function_1 = new Functions.Function1<SignalScreen, Boolean>(){

            public Boolean apply(SignalScreen it_1) {
                boolean _contains = SITEPLAN_HIDDEN_SCREENS.contains(it_1.getScreen());
                return !_contains;
            }
        };
        Iterable _filter = IterableExtensions.filter(SignalTransformator.getSignalScreen(ppsignal), (Functions.Function1)_function_1);
        Iterables.addAll((Collection)_screen, (Iterable)_filter);
        return it;
    }

    public Direction transformSignalDirection(org.eclipse.set.toolboxmodel.Signale.Signal signal) {
        ENUMWirkrichtung wirkrichtung;
        EList _punktObjektTOPKante = signal.getPunktObjektTOPKante();
        Punkt_Objekt_TOP_Kante_AttributeGroup _get = null;
        if (_punktObjektTOPKante != null) {
            _get = (Punkt_Objekt_TOP_Kante_AttributeGroup)_punktObjektTOPKante.get(0);
        }
        if ((wirkrichtung = _get.getWirkrichtung().getWert()) != null) {
            switch (wirkrichtung) {
                case ENUM_WIRKRICHTUNG_IN: {
                    return Direction.FORWARD;
                }
                case ENUM_WIRKRICHTUNG_GEGEN: {
                    return Direction.OPPOSITE;
                }
            }
            return null;
        }
        return null;
    }

    public SignalMountType getMountType(SignalInfo info) {
        boolean _notEquals;
        Functions.Function1<Signal_Befestigung, String> _function = new Functions.Function1<Signal_Befestigung, String>(){

            public String apply(Signal_Befestigung it) {
                return it.getIdentitaet().getWert();
            }
        };
        Functions.Function1<Signal_Befestigung, ENUMBefestigungArt> _function_1 = new Functions.Function1<Signal_Befestigung, ENUMBefestigungArt>(){

            public ENUMBefestigungArt apply(Signal_Befestigung it) {
                return it.getSignalBefestigungAllg().getBefestigungArt().getWert();
            }
        };
        List mounts = ListExtensions.map((List)IterableExtensions.sortBy(info.mounts, (Functions.Function1)_function), (Functions.Function1)_function_1);
        List _converted_mounts = mounts;
        int _length = ((Object[])Conversions.unwrapArray((Object)_converted_mounts, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            boolean _notEquals_1;
            Functions.Function1<ENUMBefestigungArt, SignalMountType> _function_2 = new Functions.Function1<ENUMBefestigungArt, SignalMountType>(){

                public SignalMountType apply(ENUMBefestigungArt it) {
                    return SignalTransformator.this.mapToSiteplanMountType(it);
                }
            };
            Functions.Function1<SignalMountType, Boolean> _function_3 = new Functions.Function1<SignalMountType, Boolean>(){

                public Boolean apply(SignalMountType it) {
                    return !Objects.equal((Object)it, (Object)SignalMountType.SONDERKONSTRUKTION);
                }
            };
            Iterable specificMounts = IterableExtensions.filter((Iterable)ListExtensions.map((List)mounts, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
            int _length_1 = ((Object[])Conversions.unwrapArray((Object)specificMounts, Object.class)).length;
            boolean bl2 = _notEquals_1 = _length_1 != 0;
            if (_notEquals_1) {
                SignalMountType mount = (SignalMountType)IterableExtensions.head((Iterable)specificMounts);
                if (mount == SignalMountType.MAST && ((Object[])Conversions.unwrapArray(info.signals, Object.class)).length > 1) {
                    mount = SignalMountType.MEHRERE_MASTEN;
                }
                return mount;
            }
            return SignalMountType.SONDERKONSTRUKTION;
        }
        Functions.Function1<org.eclipse.set.toolboxmodel.Signale.Signal, String> _function_4 = new Functions.Function1<org.eclipse.set.toolboxmodel.Signale.Signal, String>(){

            public String apply(org.eclipse.set.toolboxmodel.Signale.Signal it) {
                return it.getIdentitaet().getWert();
            }
        };
        org.eclipse.set.toolboxmodel.Signale.Signal signal = (org.eclipse.set.toolboxmodel.Signale.Signal)IterableExtensions.head((Iterable)IterableExtensions.sortBy(info.signals, (Functions.Function1)_function_4));
        Signal_Real_AttributeGroup _signalReal = null;
        if (signal != null) {
            _signalReal = signal.getSignalReal();
        }
        Signal_Befestigungsart_TypeClass _signalBefestigungsart = null;
        if (_signalReal != null) {
            _signalBefestigungsart = _signalReal.getSignalBefestigungsart();
        }
        ENUMSignalBefestigungsart _wert = null;
        if (_signalBefestigungsart != null) {
            _wert = _signalBefestigungsart.getWert();
        }
        SignalMountType _mapToSiteplanMountType = null;
        if (_wert != null) {
            _mapToSiteplanMountType = this.mapToSiteplanMountType(_wert);
        }
        return _mapToSiteplanMountType;
    }

    public GEOKanteCoordinate getSignalObjectCoordinate(Punkt_Objekt punktObjekt) {
        boolean _tripleNotEquals;
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt.getPunktObjektTOPKante().get(0);
        double distance = singlePoint.getAbstand().getWert().doubleValue();
        Wirkrichtung_TypeClass _wirkrichtung = singlePoint.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        ENUMWirkrichtung direction = _wert;
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint);
        GEOKanteMetadata geoKante = this.trackService.getGeoKanteAt(topKante, TopKanteExtensions.getTOPKnotenA((TOP_Kante)topKante), distance);
        double lateralDistance = 0.0;
        Seitlicher_Abstand_TypeClass _seitlicherAbstand = singlePoint.getSeitlicherAbstand();
        BigDecimal _wert_1 = null;
        if (_seitlicherAbstand != null) {
            _wert_1 = _seitlicherAbstand.getWert();
        }
        boolean bl = _tripleNotEquals = _wert_1 != null;
        if (_tripleNotEquals) {
            lateralDistance = singlePoint.getSeitlicherAbstand().getWert().doubleValue();
        } else {
            boolean _tripleEquals_1;
            GEOKanteSegment segment = geoKante.getContainingSegment(distance);
            Functions.Function1<Gleis_Art, ENUMGleisart> _function = new Functions.Function1<Gleis_Art, ENUMGleisart>(){

                public ENUMGleisart apply(Gleis_Art it) {
                    Gleisart_TypeClass _gleisart = it.getGleisart();
                    ENUMGleisart _wert = null;
                    if (_gleisart != null) {
                        _wert = _gleisart.getWert();
                    }
                    return _wert;
                }
            };
            Iterable trackType = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter(segment.getBereichObjekte(), Gleis_Art.class), (Functions.Function1)_function));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)trackType);
            if (_isEmpty) {
                lateralDistance = 0.0;
                String guid = punktObjekt.getIdentitaet().getWert();
                GEOKanteCoordinate coordinate = geoKante.getCoordinate(distance, lateralDistance, direction);
                this.recordError(guid, String.format(ERROR_NO_LATERAL_POSITION, guid), (Coordinate)this.positionService.transformPosition(coordinate));
                return coordinate;
            }
            ENUMGleisart _head = (ENUMGleisart)IterableExtensions.head((Iterable)trackType);
            boolean _tripleEquals = _head == ENUMGleisart.ENUM_GLEISART_STRECKENGLEIS;
            lateralDistance = _tripleEquals ? 3.5 : 2.25;
            Seitliche_Lage_TypeClass _seitlicheLage = singlePoint.getSeitlicheLage();
            ENUMLinksRechts _wert_2 = null;
            if (_seitlicheLage != null) {
                _wert_2 = _seitlicheLage.getWert();
            }
            boolean bl2 = _tripleEquals_1 = _wert_2 == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS;
            if (_tripleEquals_1) {
                lateralDistance = -lateralDistance;
            }
        }
        if (direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE) {
            return geoKante.getCoordinate(distance, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        }
        return geoKante.getCoordinate(distance, lateralDistance, direction);
    }

    public SignalMountType mapToSiteplanMountType(ENUMBefestigungArt mount) {
        if (mount != null) {
            switch (mount) {
                case ENUM_BEFESTIGUNG_ART_ANDERE: 
                case ENUM_BEFESTIGUNG_ART_ANDERE_SONDERKONSTRUKTION: 
                case ENUM_BEFESTIGUNG_ART_BAHNSTEIG: 
                case ENUM_BEFESTIGUNG_ART_FUNDAMENT: 
                case ENUM_BEFESTIGUNG_ART_KONSTRUKTIONSTEIL: {
                    return SignalMountType.SONDERKONSTRUKTION;
                }
                case ENUM_BEFESTIGUNG_ART_PRELLBOCK: {
                    return SignalMountType.GLEISABSCHLUSS;
                }
                case ENUM_BEFESTIGUNG_ART_WAND: {
                    return SignalMountType.WANDKONSTRUKTION;
                }
                case ENUM_BEFESTIGUNG_ART_DACH_DECKE: {
                    return SignalMountType.DECKENKONSTRUKTION;
                }
                case ENUM_BEFESTIGUNG_ART_SCHIENENFUSS: {
                    return SignalMountType.SCHIENENFUSS;
                }
                case ENUM_BEFESTIGUNG_ART_PFOSTEN_HOCH: 
                case ENUM_BEFESTIGUNG_ART_PFOSTEN_NIEDRIG: {
                    return SignalMountType.PFOSTEN;
                }
                case ENUM_BEFESTIGUNG_ART_ARBEITSBUEHNE: 
                case ENUM_BEFESTIGUNG_ART_OL_KETTENWERK: 
                case ENUM_BEFESTIGUNG_ART_OL_MAST: 
                case ENUM_BEFESTIGUNG_ART_PFAHL: 
                case ENUM_BEFESTIGUNG_ART_RAHMEN: 
                case ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_MAST_HOCH: 
                case ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_MAST_NIEDRIG: 
                case ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_SONSTIGE_HOCH: 
                case ENUM_BEFESTIGUNG_ART_REGELANORDNUNG_SONSTIGE_NIEDRIG: 
                case ENUM_BEFESTIGUNG_ART_SONDERANORDNUNG_MAST_HOCH: 
                case ENUM_BEFESTIGUNG_ART_SONDERANORDNUNG_MAST_NIEDRIG: 
                case ENUM_BEFESTIGUNG_ART_SONSTIGE: {
                    return SignalMountType.MAST;
                }
                case ENUM_BEFESTIGUNG_ART_SIGNALAUSLEGER: {
                    return SignalMountType.SIGNALAUSLEGER_LINKS;
                }
                case ENUM_BEFESTIGUNG_ART_SIGNALBRUECKE: {
                    return SignalMountType.SIGNALBRUECKE;
                }
            }
        }
        return null;
    }

    public SignalMountType mapToSiteplanMountType(ENUMSignalBefestigungsart mount) {
        if (mount != null) {
            switch (mount) {
                case ENUM_SIGNAL_BEFESTIGUNGSART_ANDERE: 
                case ENUM_SIGNAL_BEFESTIGUNGSART_FUNDAMENT: 
                case ENUM_SIGNAL_BEFESTIGUNGSART_SONDERKONSTRUKTION: {
                    return SignalMountType.SONDERKONSTRUKTION;
                }
                case ENUM_SIGNAL_BEFESTIGUNGSART_MAST: {
                    return SignalMountType.MAST;
                }
                case ENUM_SIGNAL_BEFESTIGUNGSART_SIGNALAUSLEGER: {
                    return SignalMountType.SIGNALAUSLEGER_LINKS;
                }
                case ENUM_SIGNAL_BEFESTIGUNGSART_SIGNALBRUECKE: {
                    return SignalMountType.SIGNALBRUECKE;
                }
            }
        }
        return null;
    }

    private static SignalRole getSignalRole(org.eclipse.set.toolboxmodel.Signale.Signal signal) {
        ENUMSignalArt art;
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
        if (_signalReal != null) {
            _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
        }
        Signal_Art_TypeClass _signalArt = null;
        if (_signalRealAktivSchirm != null) {
            _signalArt = _signalRealAktivSchirm.getSignalArt();
        }
        ENUMSignalArt _wert = null;
        if (_signalArt != null) {
            _wert = _signalArt.getWert();
        }
        if ((art = _wert) != null) {
            switch (art) {
                case ENUM_SIGNAL_ART_HAUPTSIGNAL: 
                case ENUM_SIGNAL_ART_HAUPTSPERRSIGNAL: 
                case ENUM_SIGNAL_ART_HAUPTSPERRSIGNAL_NE_14_LS: {
                    return SignalRole.MAIN;
                }
                case ENUM_SIGNAL_ART_VORSIGNAL: 
                case ENUM_SIGNAL_ART_VORSIGNALWIEDERHOLER: {
                    return SignalRole.PRE;
                }
                case ENUM_SIGNAL_ART_MEHRABSCHNITTSSIGNAL: 
                case ENUM_SIGNAL_ART_MEHRABSCHNITTSSPERRSIGNAL: {
                    return SignalRole.MULTI_SECTION;
                }
                case ENUM_SIGNAL_ART_ZUGDECKUNGSSIGNAL: {
                    return SignalRole.TRAIN_COVER;
                }
                case ENUM_SIGNAL_ART_SPERRSIGNAL: {
                    return SignalRole.LOCK;
                }
                case ENUM_SIGNAL_ART_ANDERE: {
                    return SignalRole.NONE;
                }
            }
        }
        return null;
    }

    private static SignalSystem getSignalSystem(org.eclipse.set.toolboxmodel.Signale.Signal signal) {
        ENUMSignalsystem art;
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
        if (_signalReal != null) {
            _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
        }
        Signalsystem_TypeClass _signalsystem = null;
        if (_signalRealAktivSchirm != null) {
            _signalsystem = _signalRealAktivSchirm.getSignalsystem();
        }
        ENUMSignalsystem _wert = null;
        if (_signalsystem != null) {
            _wert = _signalsystem.getWert();
        }
        if ((art = _wert) != null) {
            switch (art) {
                case ENUM_SIGNALSYSTEM_HL: {
                    return SignalSystem.HL;
                }
                case ENUM_SIGNALSYSTEM_HV: {
                    return SignalSystem.HV;
                }
                case ENUM_SIGNALSYSTEM_KS: {
                    return SignalSystem.KS;
                }
                case ENUM_SIGNALSYSTEM_SONSTIGE: {
                    return SignalSystem.NONE;
                }
                case ENUM_SIGNALSYSTEM_SV: {
                    return SignalSystem.SV;
                }
            }
        }
        return null;
    }

    private static List<SignalScreen> getSignalScreen(org.eclipse.set.toolboxmodel.Signale.Signal signal) {
        Functions.Function1<Signal_Rahmen, List<SignalScreen>> _function = new Functions.Function1<Signal_Rahmen, List<SignalScreen>>(){

            public List<SignalScreen> apply(final Signal_Rahmen rahmen) {
                Functions.Function1<Signal_Signalbegriff, SignalScreen> _function = new Functions.Function1<Signal_Signalbegriff, SignalScreen>(){

                    public SignalScreen apply(Signal_Signalbegriff begriff) {
                        SignalScreen signalScreen = SiteplanFactory.eINSTANCE.createSignalScreen();
                        signalScreen.setFrameType(rahmen.getRahmenArt().getWert().toString());
                        signalScreen.setScreen(begriff.getSignalbegriffID().eClass().getName());
                        Boolean _elvis = null;
                        Signal_Signalbegriff_Allg_AttributeGroup _signalSignalbegriffAllg = null;
                        if (begriff != null) {
                            _signalSignalbegriffAllg = begriff.getSignalSignalbegriffAllg();
                        }
                        Geschaltet_TypeClass _geschaltet = null;
                        if (_signalSignalbegriffAllg != null) {
                            _geschaltet = _signalSignalbegriffAllg.getGeschaltet();
                        }
                        Boolean _wert = null;
                        if (_geschaltet != null) {
                            _wert = _geschaltet.getWert();
                        }
                        _elvis = _wert != null ? _wert : Boolean.valueOf(false);
                        signalScreen.setSwitched(_elvis.booleanValue());
                        return signalScreen;
                    }
                };
                return ListExtensions.map((List)SignalRahmenExtensions.getSignalbegriffe((Signal_Rahmen)rahmen), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)SignalExtensions.signalRahmen((org.eclipse.set.toolboxmodel.Signale.Signal)signal), (Functions.Function1)_function)));
    }
}

