/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import com.google.common.base.Objects;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.graph.AbstractRouting;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.TopKantePath;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TopRouting
extends AbstractRouting<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> {
    public Set<TOP_Kante> getEdges(TOP_Knoten node) {
        return IterableExtensions.toSet(TopKnotenExtensions.getTopKanten(node));
    }

    public DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getHeadEdge(TOP_Knoten head, TOP_Kante edge) {
        Assert.isTrue((boolean)TopKanteExtensions.getTOPKnoten(edge).contains(head));
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(edge);
        boolean _equals = Objects.equal((Object)_tOPKnotenB, (Object)head);
        return new DirectedTopKante(edge, _equals);
    }

    public DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getTailEdge(TOP_Knoten tail, TOP_Kante edge) {
        Assert.isTrue((boolean)TopKanteExtensions.getTOPKnoten(edge).contains(tail));
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(edge);
        boolean _equals = Objects.equal((Object)_tOPKnotenA, (Object)tail);
        return new DirectedTopKante(edge, _equals);
    }

    public boolean isRoute(TOP_Kante origin, TOP_Kante destination, TOP_Knoten transition) {
        return TopKanteExtensions.isRoute(origin, destination, transition);
    }

    public Comparator<Double> getDistanceComparator() {
        return new Comparator<Double>(){

            @Override
            public int compare(Double d1, Double d2) {
                return Distance.compare(d1, d2);
            }
        };
    }

    public DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getEmptyPath() {
        return new TopKantePath();
    }

    public String getCacheKey() {
        return "TopRouting";
    }
}

