/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.session;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.InitializationData;
import org.eclipse.set.basis.ProjectInitializationData;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.SetFormat;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileExtension;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.viewgroups.ToolboxViewGroup;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.NilValidator;
import org.eclipse.set.feature.validation.session.ModelSession;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

@Component(service={SessionService.class})
public class SetSessionService
implements SessionService {
    protected static final Map<String, Set<ToolboxFileExtension>> PLAIN_SUPPORT_MAP;
    protected static final Map<String, Set<ToolboxFileExtension>> ZIPPED_SUPPORT_MAP;
    protected List<ToolboxViewGroup> actionItems = Lists.newLinkedList();
    protected ModelSession.ServiceProvider serviceProvider;

    static {
        HashSet ppfile = Sets.newHashSet((Object[])new ToolboxFileExtension[]{new ToolboxFileExtension("ppxml", 100), new ToolboxFileExtension("xml", 50)});
        HashSet ppmerge = Sets.newHashSet((Object[])new ToolboxFileExtension[]{new ToolboxFileExtension("mplanpro", 100)});
        PLAIN_SUPPORT_MAP = new HashMap<String, Set<ToolboxFileExtension>>();
        PLAIN_SUPPORT_MAP.put("ppall", ppfile);
        PLAIN_SUPPORT_MAP.put("ppfile", ppfile);
        HashSet ppZip = Sets.newHashSet((Object[])new ToolboxFileExtension[]{new ToolboxFileExtension("planpro", 110)});
        HashSet ppall = Sets.newHashSet((Iterable)ppZip);
        ppall.addAll(ppmerge);
        ZIPPED_SUPPORT_MAP = new HashMap<String, Set<ToolboxFileExtension>>();
        ZIPPED_SUPPORT_MAP.put("ppfile", ppZip);
        ZIPPED_SUPPORT_MAP.put("ppall", ppall);
        ZIPPED_SUPPORT_MAP.put("ppmerge", ppmerge);
    }

    protected static String getDefaultExtensionPlainPlanPro() {
        return ((ToolboxFileExtension)PLAIN_SUPPORT_MAP.get("ppfile").stream().max((a, b) -> Integer.compare(a.getPriority(), b.getPriority())).get()).getExtension();
    }

    protected static String getDefaultExtensionTemporaryIntegration() {
        return ((ToolboxFileExtension)ZIPPED_SUPPORT_MAP.get("ppmerge").stream().max((a, b) -> Integer.compare(a.getPriority(), b.getPriority())).get()).getExtension();
    }

    protected static String getDefaultExtensionZippedPlanPro() {
        return ((ToolboxFileExtension)ZIPPED_SUPPORT_MAP.get("ppfile").stream().max((a, b) -> Integer.compare(a.getPriority(), b.getPriority())).get()).getExtension();
    }

    public boolean close(IModelSession modelSession) {
        if (modelSession == null) {
            return true;
        }
        if (this.getToolboxPartService().showPart("org.eclipse.set.application.part.nosessionpart")) {
            modelSession.cleanUp();
            this.actionItems.clear();
            this.getToolboxPartService().clean();
            this.getApplication().getContext().set(IModelSession.class, null);
            return true;
        }
        return false;
    }

    public EditingDomain createEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
    }

    public String getDefaultExtension(ToolboxFile.Format format) {
        if (format.isTemporaryIntegration()) {
            return SetSessionService.getDefaultExtensionTemporaryIntegration();
        }
        if (format.isPlain()) {
            return SetSessionService.getDefaultExtensionPlainPlanPro();
        }
        if (format.isZippedPlanPro()) {
            return SetSessionService.getDefaultExtensionZippedPlanPro();
        }
        throw new IllegalArgumentException(format.toString());
    }

    public ToolboxFile.Format getFormat(Path path) {
        String extension = PathExtensions.getExtension((Path)path);
        if (PLAIN_SUPPORT_MAP.get("ppfile").stream().map(ToolboxFileExtension::getExtension).anyMatch(e -> e.equals(extension))) {
            return SetFormat.createPlainPlanPro();
        }
        if (ZIPPED_SUPPORT_MAP.get("ppfile").stream().map(ToolboxFileExtension::getExtension).anyMatch(e -> e.equals(extension))) {
            return SetFormat.createZippedPlanPro();
        }
        if (ZIPPED_SUPPORT_MAP.get("ppmerge").stream().map(ToolboxFileExtension::getExtension).anyMatch(e -> e.equals(extension))) {
            return SetFormat.createTemporaryIntegration();
        }
        throw new IllegalArgumentException("no format for " + path.toString());
    }

    public ToolboxFile.Format getInitializationFormat() {
        return this.getZippedPlanProFormat();
    }

    public ToolboxFile.Format getMergedFileFormat() {
        return SetFormat.createZippedPlanPro();
    }

    public URI getPackageUri(ToolboxFile.Format format) {
        return URI.createURI((String)"http://www.plan-pro.org/modell/PlanPro/toolbox");
    }

    public ToolboxFile.Format getPlainPlanProFormat() {
        return SetFormat.createPlainPlanPro();
    }

    public Map<String, Set<ToolboxFileExtension>> getPlainSupportMap() {
        return PLAIN_SUPPORT_MAP;
    }

    public ToolboxFile.Format getZippedPlanProFormat() {
        return SetFormat.createZippedPlanPro();
    }

    public Map<String, Set<ToolboxFileExtension>> getZippedSupportMap() {
        return ZIPPED_SUPPORT_MAP;
    }

    public void setApplication(MApplication application) {
        this.serviceProvider = (ModelSession.ServiceProvider)ContextInjectionFactory.make(ModelSession.ServiceProvider.class, (IEclipseContext)application.getContext());
    }

    protected MApplication getApplication() {
        return this.serviceProvider.application;
    }

    protected ToolboxFileService getFileService() {
        return this.serviceProvider.fileService;
    }

    protected Shell getMainWindow() {
        List mWindows = this.getApplication().getChildren();
        if (mWindows.isEmpty()) {
            return null;
        }
        return (Shell)((MWindow)mWindows.get(0)).getContext().get(Shell.class);
    }

    protected Messages getMessages() {
        return this.serviceProvider.messages;
    }

    protected ToolboxPartService getToolboxPartService() {
        return this.serviceProvider.toolboxPartService;
    }

    public ModelSession initModelSession(InitializationData projectInitializationData) {
        NilValidator.setup(this.getMessages());
        ToolboxFile toolboxFile = this.getFileService().create(this.getInitializationFormat(), ToolboxFileRole.SESSION);
        ModelSession modelSession = new ModelSession(toolboxFile, this, this.getMainWindow(), this.serviceProvider);
        modelSession.setNewProject(true);
        modelSession.setNewProjectData((ProjectInitializationData)projectInitializationData);
        return modelSession;
    }

    public ModelSession loadModelSession(Path path) {
        ModelSession modelSession = new ModelSession(this.getFileService().load(path, ToolboxFileRole.SESSION), this, this.getMainWindow(), this.serviceProvider);
        modelSession.setNewProject(false);
        return modelSession;
    }
}

