/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.widgets;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileField {
    private final Button button;
    private final DialogService dialogService;
    private final List<ToolboxFileFilter> filters;
    private Path path;
    private final List<Consumer<Path>> pathListeners = Lists.newArrayList();
    private Function<Path, Boolean> pathValidation = null;
    private final Text text;
    protected final Composite composite;

    public FileField(final Composite parent, List<ToolboxFileFilter> filters, DialogService dialogService) {
        this.filters = filters;
        this.dialogService = dialogService;
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.text = new Text(this.composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.setEditable(false);
        this.button = new Button(this.composite, 0);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FileField.this.selectFile(parent.getShell());
            }

            public void widgetSelected(SelectionEvent e) {
                FileField.this.selectFile(parent.getShell());
            }
        });
    }

    public void addPathListener(Consumer<Path> pathListener) {
        this.pathListeners.add(pathListener);
    }

    public Button getButton() {
        return this.button;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Text getText() {
        return this.text;
    }

    public boolean isEnabled() {
        return this.button.getEnabled() || this.text.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.button.setEnabled(value);
        this.text.setEnabled(value);
    }

    public void setPathValidation(Function<Path, Boolean> pathValidation) {
        this.pathValidation = pathValidation;
    }

    private boolean isValid(Path selectedPath) {
        if (this.pathValidation == null) {
            return true;
        }
        return this.pathValidation.apply(selectedPath);
    }

    protected void selectFile(Shell shell) {
        Path selectedPath;
        Optional optionalSelectedPath = this.dialogService.openFileDialog(shell, this.filters);
        if (optionalSelectedPath.isPresent() && this.isValid(selectedPath = (Path)optionalSelectedPath.get())) {
            this.path = selectedPath;
            this.text.setText(this.path.getFileName().toString());
            this.text.setToolTipText(this.path.toString());
            this.pathListeners.forEach(l -> l.accept(this.path));
        }
    }
}

