/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.helpmessages;

import com.google.common.base.Objects;
import java.lang.reflect.Field;
import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.emfforms.RendererContext;
import org.eclipse.set.core.helpmessages.HelpMessages;
import org.eclipse.set.core.services.helpmessage.HelpMessageService;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpMessageServiceImpl
implements HelpMessageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpMessageServiceImpl.class);
    @Inject
    @Translation
    private HelpMessages messages;

    public String getMessage(RendererContext rendererContext) {
        String key = this.getKey(rendererContext);
        return this.getMessage(key);
    }

    private String getKey(RendererContext rendererContext) {
        EStructuralFeature structuralFeature = (EStructuralFeature)rendererContext.get(EStructuralFeature.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("HelpMessage_");
        String _simpleName = structuralFeature.getContainerClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append("_");
        String _name = structuralFeature.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    private String getMessage(final String key) {
        try {
            String message;
            Functions.Function1<Field, Boolean> _function = new Functions.Function1<Field, Boolean>(){

                public Boolean apply(Field it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)key);
                }
            };
            Field _findFirst = (Field)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)HelpMessages.class.getDeclaredFields())), (Functions.Function1)_function);
            Object _get = null;
            if (_findFirst != null) {
                _get = _findFirst.get(this.messages);
            }
            if ((message = (String)_get) == null) {
                LOGGER.warn("Help message missing: key={}", (Object)key);
            }
            String _trim = null;
            if (message != null) {
                _trim = message.trim();
            }
            return _trim;
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalAccessException) {
                IllegalAccessException e = (IllegalAccessException)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

