/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.model.model11001.PlanPro.DocumentRoot;
import org.eclipse.set.ppmodel.extensions.PlanProResourceImplExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.util.PlanProResourceImpl;
import org.w3c.dom.Document;

public abstract class AbstractToolboxFile
implements ToolboxFile {
    private static final String NO = "no";
    protected static final String ENCODING = StandardCharsets.UTF_8.name();
    private HashMap<String, Document> domDocument = new HashMap();
    private String md5checksum = null;
    protected final HashMap<String, XMLResource> resources = new HashMap();

    public void setXMLDocument(String docName, Document doc) {
        this.domDocument.put(docName, doc);
    }

    public Document getXMLDocument(String docName) {
        return this.domDocument.get(docName);
    }

    public void clearXMLDocument() {
        this.domDocument = new HashMap();
    }

    public String getChecksum() {
        return this.md5checksum;
    }

    protected void generateMD5CheckSum() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(this.getPath().toFile());){
            this.md5checksum = DigestUtils.md5Hex((InputStream)input).toUpperCase();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void modifyXmlDeclaration() {
        XMLResource xMLResource = this.getPlanProResource();
        if (xMLResource instanceof org.eclipse.set.model.model11001.PlanPro.util.PlanProResourceImpl) {
            void planproResource;
            org.eclipse.set.model.model11001.PlanPro.util.PlanProResourceImpl planProResourceImpl = (org.eclipse.set.model.model11001.PlanPro.util.PlanProResourceImpl)xMLResource;
            org.eclipse.set.model.model11001.PlanPro.util.PlanProResourceImpl cfr_ignored_0 = (org.eclipse.set.model.model11001.PlanPro.util.PlanProResourceImpl)xMLResource;
            PlanProResourceImplExtensions.setStandalone((org.eclipse.set.model.model11001.PlanPro.util.PlanProResourceImpl)planproResource, (String)NO);
        }
    }

    protected void loadResource(Path path, EditingDomain editingDomain) throws IOException {
        XMLResource newResource;
        block3: {
            URI resourceUri;
            ResourceSet resourceSet = editingDomain.getResourceSet();
            newResource = (XMLResource)resourceSet.getResource(resourceUri = URI.createFileURI((String)PathExtensions.toLowerCaseExtension((Path)path).toString()), false);
            if (newResource == null) {
                String contentType = PathExtensions.getExtension((Path)this.getPath());
                newResource = (XMLResource)resourceSet.createResource(resourceUri, contentType);
                try {
                    newResource.load(resourceSet.getLoadOptions());
                }
                catch (Resource.IOWrappedException e) {
                    if (e.getCause() instanceof FeatureNotFoundException || e.getCause() instanceof IllegalValueException) break block3;
                    throw e;
                }
            }
        }
        this.addResource(this.getContentType(path), newResource);
    }

    protected void addResource(String contentName, XMLResource resource) {
        if (contentName == null || resource == null) {
            return;
        }
        this.resources.put(contentName, resource);
        this.modifyXmlDeclaration();
    }

    protected XMLResource getResource(String contentName) {
        return this.resources.get(contentName);
    }

    protected void setResource(String contentName, XMLResource resource) {
        this.resources.put(contentName, resource);
        this.modifyXmlDeclaration();
    }

    protected void setResourcePath(Resource resource, Path path) {
        if (!resource.getURI().isFile()) {
            String contentType = PathExtensions.getExtension((Path)this.getPath());
            XMLResource newResource = (XMLResource)this.getEditingDomain().getResourceSet().createResource(URI.createFileURI((String)path.toString()), contentType);
            newResource.setEncoding(ENCODING);
            if (!resource.getContents().isEmpty()) {
                newResource.getContents().addAll((Collection)resource.getContents());
            }
            this.resources.put(this.getContentType(path), newResource);
            this.modifyXmlDeclaration();
        } else {
            resource.setURI(URI.createFileURI((String)path.toString()));
        }
    }

    public void save() throws IOException {
        this.saveResource(this.getPlanProResource());
    }

    public void close() throws IOException {
        this.getEditingDomain().getResourceSet().getResources().clear();
        this.resources.values().forEach(resource -> resource.getContents().clear());
    }

    public DocumentRoot getPlanProSourceModel() {
        XMLResource planProResource = this.getPlanProResource();
        if (planProResource == null) {
            return null;
        }
        return ((PlanProResourceImpl)planProResource).getSourceModel();
    }

    public org.eclipse.set.model.model11001.Layoutinformationen.DocumentRoot getLayoutSourceModel() {
        XMLResource layoutResource;
        block3: {
            try {
                layoutResource = this.getLayoutResource();
                if (layoutResource != null) break block3;
                return null;
            }
            catch (UnsupportedOperationException e) {
                return null;
            }
        }
        return ((PlanProResourceImpl)layoutResource).getLayoutModel();
    }

    protected abstract void saveResource(XMLResource var1) throws IOException;

    protected abstract String getContentType(Path var1);
}

