/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.validation.ValidationService;
import org.eclipse.emf.ecp.view.spi.validation.ViewValidationListener;
import org.eclipse.set.basis.ProjectInitializationData;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.dialogservice.FilenameInitialization;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.toolboxmodel.PlanPro.Index_Ausgabe_TypeClass;
import org.eclipse.set.toolboxmodel.PlanPro.Laufende_Nummer_Ausgabe_TypeClass;
import org.eclipse.set.toolboxmodel.PlanPro.PlanProFactory;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Einzel;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.widgets.FolderField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

final class ProjectFilenameInitialization
extends FilenameInitialization<ProjectInitializationData> {
    private static final String PATTERN_FOLDER_FIELD = ".+";
    private FolderField folderField;
    private Planung_Gruppe formModel;
    private boolean formValidated = false;
    private ECPSWTView formView;
    final Messages messages;

    public ProjectFilenameInitialization(Shell shell, Messages messages, DialogService dialogService) {
        super(shell, dialogService);
        this.messages = messages;
    }

    @Override
    public String getDialogTitle() {
        return this.messages.ProjectInit_DialogTitle;
    }

    @Override
    public String getInitButtonText() {
        return this.messages.ProjectInit_InitButton;
    }

    @Override
    public ProjectInitializationData getInitializationData() {
        ProjectInitializationData data = new ProjectInitializationData();
        data.setFuehrendeOertlichkeit(this.formModel.getFuehrendeOertlichkeit().getWert());
        data.setBauzustand(this.formModel.getLSTPlanungEinzel().getPlanungEAllg().getBauzustandKurzbezeichnung().getWert());
        data.setLfdNummer(this.formModel.getLSTPlanungEinzel().getPlanungEAllg().getLaufendeNummerAusgabe().getWert());
        data.setIndex(this.formModel.getLSTPlanungEinzel().getPlanungEAllg().getIndexAusgabe().getWert());
        data.setDirectory(this.folderField.getText().getText());
        return data;
    }

    @Override
    public String getInitMessage() {
        return this.messages.ProjectInit_TitleAreaMessage;
    }

    @Override
    public String getPageTitle() {
        return this.messages.ProjectInit_Title;
    }

    private void setFormModelDefaults() {
        Planung_Einzel planungEinzel = PlanProFactory.eINSTANCE.createPlanung_Einzel();
        Planung_E_Allg_AttributeGroup planungEAllg = PlanProFactory.eINSTANCE.createPlanung_E_Allg_AttributeGroup();
        Laufende_Nummer_Ausgabe_TypeClass laufendeNummerAusgabe = PlanProFactory.eINSTANCE.createLaufende_Nummer_Ausgabe_TypeClass();
        planungEAllg.setLaufendeNummerAusgabe(laufendeNummerAusgabe);
        Index_Ausgabe_TypeClass indexAusgabe = PlanProFactory.eINSTANCE.createIndex_Ausgabe_TypeClass();
        planungEAllg.setIndexAusgabe(indexAusgabe);
        planungEinzel.setPlanungEAllg(planungEAllg);
        this.formModel.setLSTPlanungEinzel(planungEinzel);
        this.formModel.getLSTPlanungEinzel().getPlanungEAllg().getLaufendeNummerAusgabe().setWert("00");
        this.formModel.getLSTPlanungEinzel().getPlanungEAllg().getIndexAusgabe().setWert("00");
    }

    @Override
    protected String compileTooltip(String pattern) {
        return String.format(this.messages.ProjectFilenameInitialization_TooltipPattern, pattern);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        container.setLayout((Layout)new GridLayout());
        this.formModel = PlanProFactory.eINSTANCE.createPlanung_Gruppe();
        this.setFormModelDefaults();
        VViewModelLoadingProperties properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        properties.addInheritableProperty("useOnModifyDatabinding", (Object)"true");
        properties.addNonInheritableProperty("detail", (Object)false);
        VView vElement = ViewProviderHelper.getView((EObject)this.formModel, (VViewModelProperties)properties);
        ViewModelContext viewModelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)vElement, (EObject)this.formModel);
        try {
            this.formView = ECPSWTViewRenderer.INSTANCE.render(container, viewModelContext);
        }
        catch (ECPRendererException e) {
            throw new RuntimeException(e);
        }
        Label spaceLabel1 = new Label(container, 0);
        spaceLabel1.setText(new String());
        Label label = new Label(container, 0);
        label.setText(this.messages.ProjectInit_DateiSpeichern);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.folderField = new FolderField(container, this.getDialogService());
        this.folderField.getButton().setText(this.messages.ProjectInit_Ordner);
        this.folderField.getComposite().setLayoutData((Object)new GridData(4, 128, true, false));
        this.folderField.getText().setText(ToolboxConfiguration.getDefaultPath().toString());
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectFilenameInitialization.this.validate();
            }
        };
        this.folderField.getText().addModifyListener(listener);
        Label spaceLabel2 = new Label(container, 0);
        spaceLabel2.setText(new String());
        ValidationService validationService = (ValidationService)this.formView.getViewModelContext().getService(ValidationService.class);
        validationService.registerValidationListener(new ViewValidationListener(){

            public void onNewValidation(Set<Diagnostic> validationResults) {
                ProjectFilenameInitialization.this.setFormValidation(validationResults);
                ProjectFilenameInitialization.this.validate();
            }
        });
        return area;
    }

    protected void setFormValidation(Set<Diagnostic> validationResults) {
        this.formValidated = validationResults.isEmpty();
    }

    @Override
    protected void validate() {
        boolean okEnabled = true;
        okEnabled = this.formValidated && okEnabled;
        okEnabled = this.validate(this.folderField.getText(), PATTERN_FOLDER_FIELD) && okEnabled;
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(okEnabled);
        }
    }
}

