/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommand;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.threads.Threads;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroup4HeaderLayer;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroupGroupGroupHeaderLayer;
import org.eclipse.set.feature.table.abstracttableview.NatTableColumnGroupHelper;
import org.eclipse.set.feature.table.abstracttableview.ToolboxTableModelThemeConfiguration;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.feature.table.messages.MessagesWrapper;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.Headings;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.model.titlebox.extensions.TitleboxExtensions;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToFreeFieldTransformation;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.services.export.TableCompileService;
import org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.RefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.TableSelectRowByGuidEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.set.utils.table.BodyLayerStack;
import org.eclipse.set.utils.table.RowSelectionListener;
import org.eclipse.set.utils.table.TableModelInstanceBodyDataProvider;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolboxTableView
extends BasePart {
    protected static final int DEBUG_WIDTH_CORRECTION = 0;
    static final Logger logger = LoggerFactory.getLogger(ToolboxTableView.class);
    private BodyLayerStack bodyLayerStack;
    @Inject
    private TableCompileService compileService;
    @Inject
    private ExportService exportService;
    private NatTable natTable;
    private ToolboxEventHandler<NewTableTypeEvent> newTableTypeHandler;
    private final List<TableRow> tableInstances = Lists.newLinkedList();
    private ToolboxEventHandler<TableSelectRowByGuidEvent> tableSelectRowHandler;
    private int scrollToPositionRequested = -1;
    @Inject
    @Translation
    Messages messages;
    @Inject
    UISynchronize sync;
    Table table;
    @Inject
    TableService tableService;
    @Inject
    TableMenuService tableMenuService;
    TableType tableType;
    @Inject
    MessagesWrapper wrapper;

    public TableType getTableType() {
        return this.tableType;
    }

    public void handleNewTableType(NewTableTypeEvent e) {
        this.tableType = e.getTableType();
        this.updateTableView();
    }

    private ExportType getExportType() {
        switch (this.tableType) {
            case FINAL: {
                return ExportType.INVENTORY_RECORDS;
            }
            case DIFF: {
                return ExportType.PLANNING_RECORDS;
            }
            case SINGLE: {
                return ExportType.PLANNING_RECORDS;
            }
        }
        throw new IllegalArgumentException(this.tableType.toString());
    }

    private FreeFieldInfo getFreeFieldInfo() {
        PlanProToFreeFieldTransformation planProToFreeField = PlanProToFreeFieldTransformation.create();
        return planProToFreeField.transform(this.getModelSession());
    }

    private Titlebox getTitlebox(String shortcut) {
        PlanProToTitleboxTransformation planProToTitlebox = PlanProToTitleboxTransformation.create();
        Titlebox titlebox = planProToTitlebox.transform(this.getModelSession().getPlanProSchnittstelle(), this.tableService.getTableNameInfo(shortcut));
        this.updateTitlebox(titlebox);
        return titlebox;
    }

    private boolean isDisplayedDataAffected(Container_AttributeGroup container) {
        if (this.tableType == TableType.DIFF) {
            return true;
        }
        return this.getModelSession().getContainer(this.tableType.getContainerForTable()) == container;
    }

    private void outdatedUpdate() {
        if (this.isOutdated()) {
            this.updateTableView();
            this.setOutdated(false);
        }
    }

    @PostConstruct
    private void postConstruct() {
        this.tableSelectRowHandler = new DefaultToolboxEventHandler<TableSelectRowByGuidEvent>(){

            public void accept(TableSelectRowByGuidEvent t) {
                ToolboxTableView.this.tableSelectRowHandler(t);
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), TableSelectRowByGuidEvent.class, this.tableSelectRowHandler);
    }

    @PreDestroy
    private void preDestroy() {
        logger.trace("preDestroy");
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.newTableTypeHandler);
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.tableSelectRowHandler);
    }

    private Void showExportEndDialog(Shell shell) {
        this.getDialogService().reportExported(shell);
        return null;
    }

    private void tableSelectRowHandler(TableSelectRowByGuidEvent event) {
        int rowIndex = TableExtensions.getLeadingObjectRowIndexByGUID((Table)this.table, (String)event.getSearchKey());
        if (rowIndex == -1) {
            return;
        }
        this.bodyLayerStack.getSelectionLayer().selectRow(0, rowIndex, false, false);
        this.scrollToPositionRequested = rowIndex;
    }

    private Table transformToTableModel(String elementId, IModelSession modelSession) {
        return this.tableService.transformToTable(elementId, this.tableType, modelSession);
    }

    private void updateTableView() {
        this.updateModel(this.getToolboxPart(), this.getModelSession(), this.getToolboxShell());
        this.natTable.refresh();
        this.updateButtons();
    }

    private void updateTitlebox(Titlebox titlebox) {
        if (this.getExportType() == ExportType.INVENTORY_RECORDS) {
            TitleboxExtensions.set((Titlebox)titlebox, (int)81, (String)"B");
        }
    }

    protected void createView(Composite parent) {
        this.tableType = this.getModelSession().getTableType();
        if (this.tableType == null) {
            this.tableType = this.getModelSession().getNature().getDefaultContainer().getTableTypeForTables();
        }
        this.updateModel(this.getToolboxPart(), this.getModelSession(), this.getToolboxShell());
        if (this.table == null) {
            return;
        }
        ColumnDescriptor rootColumnDescriptor = (ColumnDescriptor)this.table.getColumndescriptors().get(0);
        if (logger.isDebugEnabled()) {
            logger.info(Headings.getTreeString((ColumnDescriptor)rootColumnDescriptor));
            logger.info(Headings.getWidthTestCsv((ColumnDescriptor)rootColumnDescriptor, input -> {
                if (input == null) {
                    return 0;
                }
                return ToolboxTableModelThemeConfiguration.toPixel(input.floatValue()) + 0;
            }));
        }
        Assert.isNotNull(this.tableInstances);
        TableModelInstanceBodyDataProvider bodyDataProvider = new TableModelInstanceBodyDataProvider(TableExtensions.getPropertyCount((Table)this.table), this.tableInstances);
        SpanningDataLayer bodyDataLayer = new SpanningDataLayer((ISpanningDataProvider)bodyDataProvider);
        this.bodyLayerStack = new BodyLayerStack((DataLayer)bodyDataLayer);
        this.bodyLayerStack.freezeColumns(this.tableService.getFixedColumns(this.getToolboxPart().getElementId()));
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        selectionLayer.addConfiguration((IConfiguration)new RowSelectionListener(this.getToolboxPart().getElementId(), selectionLayer, this.tableInstances, this.getBroker()));
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(ColumnDescriptorExtensions.getColumnLabels((ColumnDescriptor)rootColumnDescriptor));
        DataLayer columnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        ColumnGroupModel columnGroupModel = new ColumnGroupModel();
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)columnHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroupModel);
        NatTableColumnGroupHelper.addGroups(rootColumnDescriptor, columnGroupHeaderLayer);
        columnGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        ColumnGroupModel columnGroupGroupModel = new ColumnGroupModel();
        ColumnGroupGroupHeaderLayer columnGroupGroupHeaderLayer = new ColumnGroupGroupHeaderLayer(columnGroupHeaderLayer, columnGroupGroupModel);
        NatTableColumnGroupHelper.addGroupGroups(rootColumnDescriptor, columnGroupGroupHeaderLayer);
        columnGroupGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        ColumnGroupModel columnGroupGroupGroupModel = new ColumnGroupModel();
        ColumnGroupGroupGroupHeaderLayer columnGroupGroupGroupHeaderLayer = new ColumnGroupGroupGroupHeaderLayer(columnGroupGroupHeaderLayer, columnGroupHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroupGroupGroupModel);
        NatTableColumnGroupHelper.addGroupGroupGroups(rootColumnDescriptor, columnGroupGroupGroupHeaderLayer);
        columnGroupGroupGroupHeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroupGroupGroupRowHeight((ColumnDescriptor)rootColumnDescriptor)));
        ColumnGroupModel columnGroup4Model = new ColumnGroupModel();
        ColumnGroup4HeaderLayer columnGroup4HeaderLayer = new ColumnGroup4HeaderLayer(columnGroupGroupGroupHeaderLayer, columnGroupGroupHeaderLayer, columnGroupHeaderLayer, this.bodyLayerStack.getSelectionLayer(), columnGroup4Model);
        NatTableColumnGroupHelper.addColumnNumbers(rootColumnDescriptor, columnGroup4HeaderLayer);
        columnGroup4HeaderLayer.setRowHeight(ToolboxTableModelThemeConfiguration.toPixel((float)ColumnDescriptorExtensions.getGroup4RowHeight((ColumnDescriptor)rootColumnDescriptor)));
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DataLayer rowHeaderDataLayer = new DataLayer((IDataProvider)rowHeaderDataProvider, 40, 20);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnGroup4HeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)this.bodyLayerStack, (ILayer)columnGroup4HeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.natTable = new NatTable(parent, (ILayer)gridLayer, false);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 500).applyTo((Control)this.natTable);
        this.tableMenuService.createDefaultMenuItems((BasePart)this, this.table, (IDataProvider)bodyDataProvider, selectionLayer);
        this.natTable.addConfiguration((IConfiguration)this.tableMenuService.createMenuConfiguration(this.natTable, selectionLayer));
        this.natTable.configure();
        this.natTable.setTheme((ThemeConfiguration)new ToolboxTableModelThemeConfiguration(this.natTable, (AbstractLayer)columnHeaderDataLayer, (DataLayer)bodyDataLayer, gridLayer, rootColumnDescriptor, (AbstractLayer)this.bodyLayerStack, (IDataProvider)bodyDataProvider, s -> this.showExportEndDialog(this.getToolboxShell())));
        this.bodyLayerStack.getSelectionLayer().clear();
        Text tableFooting = new Text(parent, 2);
        tableFooting.setText(TableExtensions.getFootnotesText((Table)this.table));
        tableFooting.setEditable(false);
        this.getBanderole().setExportAction(new SelectableAction(){

            public String getText() {
                return ToolboxTableView.this.messages.ToolboxTableView_Export;
            }

            public void selected(SelectionEvent e) {
                ToolboxTableView.this.export();
            }
        });
        CommandStackListener commandStackListener = event -> this.sync.syncExec(this::updateButtons);
        this.getModelSession().getEditingDomain().getCommandStack().addCommandStackListener(commandStackListener);
        this.natTable.addDisposeListener(event -> this.getModelSession().getEditingDomain().getCommandStack().removeCommandStackListener(commandStackListener));
        this.natTable.addPaintListener(e -> {
            if (this.scrollToPositionRequested != -1) {
                this.natTable.doCommand((ILayerCommand)new ShowRowInViewportCommand(this.scrollToPositionRequested));
                this.scrollToPositionRequested = -1;
            }
        });
        this.updateButtons();
    }

    protected SelectableAction getOutdatedAction() {
        return new RefreshAction((BasePart)this, e -> this.outdatedUpdate());
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        if (this.isDisplayedDataAffected(e.getContainer())) {
            this.setOutdated(true);
        }
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.outdatedUpdate();
    }

    void export() {
        String id = this.getToolboxPart().getElementId();
        String shortcut = this.tableService.extractShortcut(id);
        Map tables = this.compileService.compile(shortcut, this.getModelSession());
        Optional optionalOutputDir = this.getDialogService().selectDirectory(this.getToolboxShell(), ToolboxConfiguration.getDefaultPath().toString());
        try {
            this.getDialogService().showProgress(this.getToolboxShell(), monitor -> optionalOutputDir.ifPresent(outputDir -> {
                monitor.beginTask(this.messages.ToolboxTableView_ExportTable, -1);
                this.exportService.export(tables, this.getExportType(), this.getTitlebox(shortcut), this.getFreeFieldInfo(), shortcut, outputDir, this.getModelSession().getToolboxPaths(), this.getModelSession().getTableType(), OverwriteHandling.forUserConfirmation(path -> this.getDialogService().confirmOverwrite(this.getToolboxShell(), path)), (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
            }));
            optionalOutputDir.ifPresent(outputDir -> this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), Paths.get(outputDir, new String[0])));
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.getDialogService().error(this.getToolboxShell(), e);
        }
    }

    void updateButtons() {
        this.getBanderole().setEnableExport(this.getTableType() != TableType.INITIAL && !this.getModelSession().isDirty());
    }

    void updateModel(MPart part, IModelSession modelSession, Shell shell) {
        this.getBanderole().setTableType(this.tableType);
        IRunnableWithProgress generateTableInstancesThread = monitor -> {
            monitor.beginTask(this.messages.Abstracttableview_transformation_progress, -1);
            Threads.stopCurrentOnCancel((IProgressMonitor)monitor);
            this.table = this.transformToTableModel(part.getElementId(), modelSession);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.done();
            logger.info("ProgressMonitorDialog done.");
        };
        logger.info("Start ProgressMonitorDialog...");
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(shell);
        try {
            monitorDialog.run(true, true, generateTableInstancesThread);
        }
        catch (InvocationTargetException ex) {
            logger.error(ex.toString(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            this.tableInstances.clear();
            MApplicationElementExtensions.setViewState((MApplicationElement)part, (ToolboxViewState)ToolboxViewState.CANCELED);
            return;
        }
        MApplicationElementExtensions.setViewState((MApplicationElement)part, (ToolboxViewState)ToolboxViewState.CREATED);
        this.tableInstances.clear();
        this.tableInstances.addAll(TableExtensions.getTableRows((Table)this.table));
    }
}

