/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.menu;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.events.JumpToSourceLineEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.table.TableDataProvider;
import org.eclipse.set.utils.table.menu.TableBodyMenuConfiguration;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractTableMenuService
implements TableMenuService {
    private static final String SOURCE_TEXT_VIEWER_PART_ID = "org.eclipse.set.application.descriptions.SourceWebTextViewDescriptionService";
    @Inject
    ToolboxPartService toolboxPartService;
    @Inject
    protected IEventBroker broker;
    protected Set<IMenuItemProvider> menuItems = new HashSet<IMenuItemProvider>();
    protected TableBodyMenuConfiguration tableBodyMenuConfiguration;

    @Override
    public TableBodyMenuConfiguration createMenuConfiguration(NatTable natTable, SelectionLayer selectionLayer) {
        this.tableBodyMenuConfiguration = new TableBodyMenuConfiguration(natTable, selectionLayer, this.menuItems);
        return this.tableBodyMenuConfiguration;
    }

    protected void createShowInTextViewItem(String label, final ToolboxEvent toolboxEvent) {
        this.menuItems.add(this.createMenuItem(label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractTableMenuService.this.tableBodyMenuConfiguration.selectionLayer.getSelectedCells().isEmpty()) {
                    return;
                }
                AbstractTableMenuService.this.toolboxPartService.showPart(AbstractTableMenuService.SOURCE_TEXT_VIEWER_PART_ID);
                ToolboxEvents.send((IEventBroker)AbstractTableMenuService.this.broker, (ToolboxEvent)toolboxEvent);
            }
        }));
    }

    @Override
    public IMenuItemProvider createMenuItem(String label, SelectionListener selectionListener) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(label);
            menuItem.setEnabled(true);
            menuItem.addSelectionListener(selectionListener);
        };
    }

    @Override
    public void addMenuItem(IMenuItemProvider menuItem) {
        this.menuItems.add(menuItem);
    }

    protected void createDefaultMenuItems(String viewItemTitle, BasePart part, final Table table, final IDataProvider dataProvider, final SelectionLayer selectionLayer) {
        this.createShowInTextViewItem(viewItemTitle, (ToolboxEvent)new JumpToSourceLineEvent(part){

            /*
             * WARNING - void declaration
             */
            public Pair<ObjectScope, Integer> getLineNumber() {
                Collection selectedCells = selectionLayer.getSelectedCells();
                if (selectedCells.isEmpty()) {
                    return new Pair(null, (Object)-1);
                }
                int rowPosition = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
                IDataProvider iDataProvider = dataProvider;
                if (iDataProvider instanceof TableDataProvider) {
                    void tableDataProvider;
                    TableDataProvider tableDataProvider2 = (TableDataProvider)iDataProvider;
                    TableDataProvider cfr_ignored_0 = (TableDataProvider)iDataProvider;
                    int originalRow = tableDataProvider.getOriginalRowIndex(rowPosition);
                    String objectScope = tableDataProvider.getObjectScope(rowPosition);
                    ObjectScope scope = ObjectScope.get((String)objectScope);
                    Integer lineNumber = tableDataProvider.getObjectSourceLine(originalRow);
                    return new Pair((Object)scope, (Object)lineNumber);
                }
                return new Pair(null, (Object)-1);
            }

            public String getObjectGuid() {
                Collection selectedCells = selectionLayer.getSelectedCells();
                if (selectedCells.isEmpty()) {
                    return null;
                }
                int rowPosition = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
                List tableRows = TableExtensions.getTableRows((Table)table);
                return TableRowExtensions.getLeadingObjectGuid((TableRow)((TableRow)tableRows.get(rowPosition)));
            }
        });
    }
}

