/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.wizard.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.framework.device.wizard.model.DeviceWizardBean;

public class DeviceWizardExtensionManager {
    private static DeviceWizardExtensionManager mgr = new DeviceWizardExtensionManager();
    private final Map<String, String> deviceWizardIds = new LinkedHashMap<String, String>();

    private DeviceWizardExtensionManager() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tml.device.wizard");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String device = PluginUtils.getPluginAttribute((IExtension)extension, (String)"usage", (String)"device");
            this.deviceWizardIds.put(device, extension.getUniqueIdentifier());
            ++n2;
        }
    }

    public IWizard getDeviceWizard(String deviceId) {
        IWizard wizard = null;
        String extensionId = this.deviceWizardIds.get(deviceId);
        if (extensionId != null) {
            try {
                Object executable = PluginUtils.getExecutableAttribute((IExtension)PluginUtils.getExtension((String)extensionId), (String)"usage", (String)"class");
                if (executable instanceof IWizard) {
                    wizard = (IWizard)executable;
                }
            }
            catch (CoreException coreException) {}
        }
        return wizard;
    }

    public static DeviceWizardExtensionManager getInstance() {
        return mgr;
    }

    public DeviceWizardBean getDeviceWizardBean(String id) {
        return new DeviceWizardBean(id);
    }
}

