/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.theme.CssBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.internal.widgets.shellkit.ShellLCA;
import org.eclipse.swt.internal.widgets.shellkit.ShellThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    private static final BoxDimensions ZERO = new BoxDimensions(0, 0, 0, 0);
    private static final int MODE_NONE = 0;
    private static final int MODE_MAXIMIZED = 1;
    private static final int MODE_MINIMIZED = 2;
    private static final int MODE_FULLSCREEN = 4;
    private static final int INITIAL_SIZE_PERCENT = 60;
    private static final int MIN_WIDTH_LIMIT = 30;
    private Control lastActive;
    private transient IShellAdapter shellAdapter;
    private int alpha;
    private Rectangle savedBounds;
    private int mode;
    private boolean modified;
    private int minWidth;
    private int minHeight;
    private ToolTip[] toolTips;

    private Shell(Display display, Shell parent, int style) {
        super(Shell.checkParent(parent));
        if (display != null) {
            this.display = display;
        } else {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = Display.getDefault();
            }
        }
        this.alpha = 255;
        this.mode = 0;
        this.style = Shell.checkStyle(style);
        this.addState(16);
        this.minWidth = 30;
        this.minHeight = this.getMinHeightLimit();
        this.display.addShell(this);
        this.reskinWidget();
        this.createWidget();
        this.setInitialSize();
    }

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style);
    }

    @Override
    Shell internalGetShell() {
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        return this.internalGetShells();
    }

    private Shell[] internalGetShells() {
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell._getParent()) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell._getParent()) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public void setActive() {
        this.checkWidget();
        if (this.isVisible()) {
            this.display.setActiveShell(this);
        }
    }

    public void forceActive() {
        this.checkWidget();
        this.setActive();
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        BoxDimensions padding = this.getPadding();
        BoxDimensions titleBarMargin = this.getTitleBarMargin();
        int hTopTrim = titleBarMargin.top + titleBarMargin.bottom;
        hTopTrim += this.getTitleBarHeight();
        hTopTrim += this.getMenuBarHeight();
        BoxDimensions border = this.getBorder();
        int padingWidth = padding.left + padding.right;
        int paddingHeight = padding.top + padding.bottom;
        int borderWidth = border.left + border.right;
        int borderHeight = border.top + border.bottom;
        return new Rectangle(padding.left, hTopTrim + padding.top, bounds.width - padingWidth - borderWidth, bounds.height - hTopTrim - paddingHeight - borderHeight);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int hTopTrim = this.getTopTrim();
        BoxDimensions padding = this.getPadding();
        BoxDimensions border = this.getBorder();
        int paddingWidth = padding.left + padding.right;
        int paddingHeight = padding.top + padding.bottom;
        int borderWidth = border.left + border.right;
        int borderHeight = border.top + border.bottom;
        return new Rectangle(x - padding.left - border.left, y - hTopTrim - padding.top - border.top, width + paddingWidth + borderWidth, height + hTopTrim + paddingHeight + borderHeight);
    }

    private void setInitialSize() {
        int width = this.display.getBounds().width * 60 / 100;
        int height = this.display.getBounds().height * 60 / 100;
        this._setBounds(new Rectangle(0, 0, width, height));
    }

    private int getMinHeightLimit() {
        BoxDimensions border = this.getBorder();
        BoxDimensions titleBarMargin = this.getTitleBarMargin();
        int titleBarHeight = this.getTitleBarHeight();
        return titleBarMargin.top + titleBarMargin.bottom + titleBarHeight + border.top + border.bottom;
    }

    private Rectangle getMenuBounds() {
        Rectangle result = null;
        if (this.getMenuBar() == null) {
            result = new Rectangle(0, 0, 0, 0);
        } else {
            Rectangle bounds = this.getBounds();
            int hTop = (this.style & 0x20) != 0 ? 1 : 0;
            BoxDimensions padding = this.getPadding();
            BoxDimensions border = this.getBorder();
            int paddingWidth = padding.left + padding.right;
            int borderWidth = border.left + border.right;
            result = new Rectangle(padding.left, (hTop += this.getTitleBarHeight()) + padding.top, bounds.width - paddingWidth - borderWidth, this.getMenuBarHeight());
        }
        return result;
    }

    @Override
    public int getBorderWidth() {
        return this.getFullScreen() ? 0 : super.getBorderWidth();
    }

    @Override
    BoxDimensions getBorder() {
        return this.getFullScreen() ? ZERO : super.getBorder();
    }

    private int getTopTrim() {
        BoxDimensions titleBarMargin = this.getTitleBarMargin();
        return titleBarMargin.top + titleBarMargin.bottom + this.getTitleBarHeight() + this.getMenuBarHeight();
    }

    private int getTitleBarHeight() {
        int result = 0;
        if (!this.getFullScreen()) {
            result = this.getThemeAdapter().getTitleBarHeight(this);
        }
        return result;
    }

    private BoxDimensions getTitleBarMargin() {
        if (!this.getFullScreen()) {
            return this.getThemeAdapter().getTitleBarMargin(this);
        }
        return CssBoxDimensions.ZERO.dimensions;
    }

    private int getMenuBarHeight() {
        return this.getThemeAdapter().getMenuBarHeight(this);
    }

    private ShellThemeAdapter getThemeAdapter() {
        return (ShellThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }

    @Override
    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    @Override
    void updateMode() {
        this.mode &= 0xFFFFFFFE;
        this.mode &= 0xFFFFFFFD;
        this.mode &= 0xFFFFFFFB;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IShellAdapter.class) {
            if (this.shellAdapter == null) {
                this.shellAdapter = new ShellAdapter();
            }
            return (T)this.shellAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)ShellLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.getEnabled() != enabled) {
            super.setEnabled(enabled);
            if (enabled && !this.restoreFocus()) {
                this.traverseGroup(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    @Override
    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkWidget();
        boolean wasVisible = this.getVisible();
        super.setVisible(visible);
        if (visible && !wasVisible && !this.isDisposed()) {
            this.changed(this.getChildren());
            this.layout(true, true);
        }
    }

    public void open() {
        this.checkWidget();
        this.display.setActiveShell(this);
        this.bringToTop();
        this.setVisible(true);
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public void close() {
        this.checkWidget();
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                Event event = new Event();
                Shell.this.notifyListeners(21, event);
                if (event.doit) {
                    Shell.this.dispose();
                }
            }
        });
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        this.alpha = alpha & 0xFF;
    }

    public int getAlpha() {
        this.checkWidget();
        return this.alpha;
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        this.minWidth = Math.max(30, width);
        this.minHeight = Math.max(this.getMinHeightLimit(), height);
        Point size = this.getSize();
        int newWidth = Math.max(size.x, this.minWidth);
        int newHeight = Math.max(size.y, this.minHeight);
        if (newWidth != size.x || newHeight != size.y) {
            this.setSize(newWidth, newHeight);
        }
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return new Point(this.minWidth, this.minHeight);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        int newWidth = Math.max(bounds.width, this.minWidth);
        int newHeight = Math.max(bounds.height, this.minHeight);
        super.setBounds(new Rectangle(bounds.x, bounds.y, newWidth, newHeight));
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        return null;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(21, listener);
        this.removeListener(26, listener);
        this.removeListener(27, listener);
    }

    @Override
    void releaseChildren() {
        Menu[] menus;
        super.releaseChildren();
        Shell[] dialogShells = this.internalGetShells();
        int i = 0;
        while (i < dialogShells.length) {
            dialogShells[i].dispose();
            ++i;
        }
        Menu[] menuArray = menus = this.getAdapter(MenuHolder.class).getMenus();
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            Menu menu = menuArray[n2];
            menu.dispose();
            ++n2;
        }
        if (this.toolTips != null) {
            int i2 = 0;
            while (i2 < this.toolTips.length) {
                if (this.toolTips[i2] != null) {
                    this.toolTips[i2].dispose();
                }
                ++i2;
            }
        }
    }

    @Override
    void releaseParent() {
        this.display.removeShell(this);
    }

    void setActiveControl(Control activateControl) {
        Control control = activateControl;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive != control) {
            Control[] activate = control == null ? new Control[]{} : control.getPath();
            Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
            this.lastActive = control;
            int index = 0;
            int length = Math.min(activate.length, deactivate.length);
            while (index < length && activate[index] == deactivate[index]) {
                ++index;
            }
            int i = deactivate.length - 1;
            while (i >= index) {
                if (!deactivate[i].isDisposed()) {
                    deactivate[i].notifyListeners(27, new Event());
                }
                --i;
            }
            i = activate.length - 1;
            while (i >= index) {
                if (!activate[i].isDisposed()) {
                    activate[i].notifyListeners(26, new Event());
                }
                --i;
            }
        }
    }

    private void bringToTop() {
        IDisplayAdapter adapter;
        IDisplayAdapter displayAdapter = adapter = this.display.getAdapter(IDisplayAdapter.class);
        displayAdapter.setFocusControl(this, true);
        displayAdapter.invalidateFocus();
    }

    private boolean traverseGroup(boolean next) {
        boolean result = false;
        if (this.getChildren().length > 0) {
            result = this.getChildren()[0].forceFocus();
        }
        return result;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (minimized) {
            this.mode |= 2;
        } else {
            if ((this.mode & 2) != 0) {
                this.setActive();
            }
            this.mode &= 0xFFFFFFFD;
        }
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if ((this.mode & 4) == 0) {
            if (maximized) {
                if ((this.mode & 1) == 0) {
                    this.setActive();
                    this.savedBounds = this.getBounds();
                    this.setBounds(this.display.getBounds(), false);
                }
                this.mode |= 1;
                this.mode &= 0xFFFFFFFD;
            } else {
                if ((this.mode & 1) != 0) {
                    this.setBounds(this.savedBounds, false);
                }
                this.mode &= 0xFFFFFFFE;
            }
        }
    }

    public boolean getMinimized() {
        this.checkWidget();
        return (this.mode & 2) != 0;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return (this.mode & 4) == 0 && (this.mode & 2) == 0 && (this.mode & 1) != 0;
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if ((this.mode & 4) != 0 != fullScreen) {
            if (fullScreen) {
                this.setActive();
                if ((this.mode & 1) == 0) {
                    this.savedBounds = this.getBounds();
                }
                this.setBounds(this.display.getBounds(), false);
                this.mode |= 4;
                this.mode &= 0xFFFFFFFD;
            } else {
                if ((this.mode & 1) == 0) {
                    this.setBounds(this.savedBounds, false);
                }
                this.mode &= 0xFFFFFFFB;
            }
            this.layout();
        }
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return (this.mode & 4) != 0;
    }

    void fixShell(Shell newShell, Control control) {
        if (newShell != this && control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    void createToolTip(ToolTip toolTip) {
        int id = 0;
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        while (id < this.toolTips.length && this.toolTips[id] != null) {
            ++id;
        }
        if (id == this.toolTips.length) {
            ToolTip[] newToolTips = new ToolTip[this.toolTips.length + 4];
            System.arraycopy(this.toolTips, 0, newToolTips, 0, this.toolTips.length);
            this.toolTips = newToolTips;
        }
        this.toolTips[id] = toolTip;
    }

    void destroyToolTip(ToolTip toolTip) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.toolTips.length) {
            if (this.toolTips[i] == toolTip) {
                this.toolTips[i] = null;
                found = true;
            }
            ++i;
        }
    }

    private ToolTip[] getToolTips() {
        ToolTip[] result;
        if (this.toolTips == null) {
            result = new ToolTip[]{};
        } else {
            int count = 0;
            int i = 0;
            while (i < this.toolTips.length) {
                if (this.toolTips[i] != null) {
                    ++count;
                }
                ++i;
            }
            result = new ToolTip[count];
            int index = 0;
            int i2 = 0;
            while (i2 < this.toolTips.length) {
                if (this.toolTips[i2] != null) {
                    result[index] = this.toolTips[i2];
                    ++index;
                }
                ++i2;
            }
        }
        return result;
    }

    private static Shell checkParent(Shell parent) {
        if (parent != null && parent.isDisposed()) {
            SWT.error(5);
        }
        return parent;
    }

    @Override
    void reskinChildren(int flags) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null) {
                shell.reskin(flags);
            }
            ++i;
        }
        super.reskinChildren(flags);
    }

    private class ShellAdapter
    implements IShellAdapter {
        private ShellAdapter() {
        }

        @Override
        public Control getActiveControl() {
            return Shell.this.lastActive;
        }

        @Override
        public void setActiveControl(Control control) {
            Shell.this.setActiveControl(control);
        }

        @Override
        public Rectangle getMenuBounds() {
            return Shell.this.getMenuBounds();
        }

        @Override
        public int getTopTrim() {
            return Shell.this.getTopTrim();
        }

        @Override
        public void setBounds(Rectangle bounds) {
            Shell.this.setBounds(bounds, false);
        }

        @Override
        public ToolTip[] getToolTips() {
            return Shell.this.getToolTips();
        }
    }
}

