/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.ReparentedControls;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.rap.rwt.theme.ControlThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ControlRemoteAdapter;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    private transient IControlAdapter controlAdapter;
    private Composite parent;
    private int tabIndex;
    private Rectangle bounds;
    private Object layoutData;
    private String toolTipText;
    private Menu menu;
    private Listener menuDisposeListener;
    private Color foreground;
    private Color background;
    private Image backgroundImage;
    private boolean backgroundTransparency;
    private Font font;
    private Cursor cursor;
    private BoxDimensions bufferedPadding;
    private transient Accessible accessible;
    private boolean packed;

    Control(Composite parent) {
        this.parent = parent;
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.tabIndex = -1;
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.controlAdapter = new ControlAdapter();
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.tabIndex = -1;
        parent.addChild(this);
        this.createWidget();
    }

    void createWidget() {
        this.initState();
        this.checkOrientation(this.parent);
        this.checkMirrored();
        this.checkBackground();
        this.updateBackground();
    }

    void initState() {
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Composite _getParent() {
        return this.parent;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.internalGetShell();
    }

    Shell internalGetShell() {
        return this.parent.internalGetShell();
    }

    public Monitor getMonitor() {
        this.checkWidget();
        return this.display.getPrimaryMonitor();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.hasState(16) != !visible) {
            this.preserveState(16);
            this.internalSetVisible(visible);
        }
    }

    private void internalSetVisible(boolean visible) {
        if (this.hasState(16) != !visible) {
            if (visible) {
                this.notifyListeners(22, null);
            }
            Control control = null;
            boolean fixFocus = false;
            if (!visible) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            if (visible) {
                this.removeState(16);
            } else {
                this.addState(16);
            }
            if (!visible) {
                this.notifyListeners(23, null);
            }
            if (fixFocus) {
                this.fixFocus(control);
            }
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public boolean getVisible() {
        this.checkWidget();
        return !this.hasState(16);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.hasState(8) != !enabled) {
            this.preserveState(8);
            this.internalSetEnabled(enabled);
        }
    }

    private void internalSetEnabled(boolean enabled) {
        if (this.hasState(8) != !enabled) {
            Control control = null;
            boolean fixFocus = false;
            if (!enabled) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            if (enabled) {
                this.removeState(8);
            } else {
                this.addState(8);
            }
            if (fixFocus) {
                this.fixFocus(control);
            }
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return !this.hasState(8);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        this.getRemoteAdapter().preserveBackground(this.background, this.backgroundTransparency);
        this.background = color;
        this.updateBackground();
    }

    public Color getBackground() {
        Color result;
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((result = control.background) == null) {
            result = this.getControlThemeAdapter().getBackground(control);
        }
        Shell shell = control.getShell();
        control = control.parent;
        while (result == null && control != null) {
            result = control.getBackground();
            Control control2 = control = control == shell ? null : control.parent;
        }
        if (result == null) {
            throw new IllegalStateException("Transparent shell background color");
        }
        return result;
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.backgroundImage != image) {
            this.getRemoteAdapter().preserveBackgroundImage(this.backgroundImage);
            this.backgroundImage = image;
        }
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        this.getRemoteAdapter().preserveForeground(this.foreground);
        this.foreground = color;
    }

    public Color getForeground() {
        this.checkWidget();
        Color result = this.foreground;
        if (result == null) {
            result = this.getControlThemeAdapter().getForeground(this);
        }
        if (result == null) {
            throw new IllegalStateException("Transparent foreground color");
        }
        return result;
    }

    void updateBackgroundMode() {
        boolean oldState = this.hasState(1024);
        this.checkBackground();
        if (oldState != this.hasState(1024)) {
            this.updateBackground();
        }
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.removeState(1024);
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if (control.hasState(256)) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.addState(1024);
                return;
            }
            if (composite == shell) break;
            composite = composite._getParent();
        }
    }

    private void updateBackground() {
        this.getRemoteAdapter().preserveBackground(this.background, this.backgroundTransparency);
        this.backgroundTransparency = this.background == null && this.backgroundImage == null && this.hasState(1024);
    }

    Control findBackgroundControl() {
        Control result = null;
        if (this.background != null || this.backgroundImage != null) {
            result = this;
        } else if (this.hasState(1024)) {
            result = this.parent.findBackgroundControl();
        }
        return result;
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.getRemoteAdapter().preserveFont(this.font);
        this.font = font;
    }

    public Font getFont() {
        this.checkWidget();
        Font result = this.font;
        if (result == null) {
            result = this.getControlThemeAdapter().getFont(this);
        }
        return result;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.getRemoteAdapter().preserveCursor(this.cursor);
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean setFocus() {
        this.checkWidget();
        boolean result = false;
        if ((this.style & 0x80000) == 0) {
            result = this.forceFocus();
        }
        return result;
    }

    public boolean forceFocus() {
        this.checkWidget();
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        this.setFocusControl(this);
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.isFocusControl();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this == this.getDisplay().getFocusControl();
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public void setBounds(Rectangle bounds) {
        this.checkWidget();
        if (bounds == null) {
            SWT.error(4);
        }
        this.setBounds(bounds, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    public void setLocation(Point location) {
        if (location == null) {
            SWT.error(4);
        }
        Rectangle newBounds = new Rectangle(location.x, location.y, this.bounds.width, this.bounds.height);
        this.setBounds(newBounds);
    }

    public void setLocation(int x, int y) {
        this.setLocation(new Point(x, y));
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.bounds.x, this.bounds.y);
    }

    public void setSize(Point size) {
        if (size == null) {
            SWT.error(4);
        }
        this.setBounds(new Rectangle(this.bounds.x, this.bounds.y, size.x, size.y));
    }

    public void setSize(int width, int height) {
        this.setSize(new Point(width, height));
    }

    public Point getSize() {
        this.checkWidget();
        return new Point(this.bounds.width, this.bounds.height);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        BoxDimensions border = this.getBorder();
        return new Point(width += border.left + border.right, height += border.top + border.bottom);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
        this.packed = true;
    }

    public int getBorderWidth() {
        this.checkWidget();
        BoxDimensions border = this.getBorder();
        int max1 = Math.max(border.left, border.right);
        int max2 = Math.max(border.top, border.bottom);
        return Math.max(max1, max2);
    }

    BoxDimensions getBorder() {
        return this.getControlThemeAdapter().getBorder(this);
    }

    BoxDimensions getPadding() {
        if (this.bufferedPadding == null) {
            this.bufferedPadding = this.getControlThemeAdapter().getPadding(this);
        }
        return this.bufferedPadding;
    }

    private ControlThemeAdapter getControlThemeAdapter() {
        return this.getAdapter(ControlThemeAdapter.class);
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        return this.getDisplay().map(null, this, x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        return this.getDisplay().map(this, null, x, y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    void markLayout(boolean changed, boolean all) {
    }

    void updateLayout(boolean resize, boolean all) {
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        if (toolTipText != null && MarkupUtil.isToolTipMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(toolTipText);
        }
        this.getRemoteAdapter().preserveToolTipText(this.toolTipText);
        this.toolTipText = toolTipText;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (this.menu != menu) {
            if (menu != null) {
                if (menu.isDisposed()) {
                    SWT.error(5);
                }
                if ((menu.getStyle() & 8) == 0) {
                    SWT.error(37);
                }
                if (menu.getParent() != this.getShell()) {
                    SWT.error(32);
                }
            }
            this.removeMenuDisposeListener();
            this._setMenu(menu);
            this.addMenuDisposeListener();
        }
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (!(this instanceof Shell) && (control == null || control.parent == this.parent && control != this)) {
            this.parent.moveAbove(this, control);
        }
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (!(this instanceof Shell) && (control == null || control.parent == this.parent && control != this)) {
            this.parent.moveBelow(this, control);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result = null;
        if (adapter == IControlAdapter.class) {
            if (this.controlAdapter == null) {
                this.controlAdapter = new ControlAdapter();
            }
            result = this.controlAdapter;
        } else {
            result = adapter == ControlThemeAdapter.class ? super.getAdapter(ThemeAdapter.class) : super.getAdapter(adapter);
        }
        return (T)result;
    }

    @Override
    RemoteAdapter createRemoteAdapter(Widget parent, String id) {
        ControlRemoteAdapter remoteAdapter = new ControlRemoteAdapter(id);
        remoteAdapter.setParent(parent);
        return remoteAdapter;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(10, typedListener);
        this.addListener(11, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(10, listener);
        this.removeListener(11, listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(3, listener);
        this.removeListener(4, listener);
        this.removeListener(8, listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(2, listener);
        this.removeListener(1, listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(31, listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(15, listener);
        this.removeListener(16, listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(28, listener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(29, listener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(35, listener);
    }

    public void requestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        this.internalSetRedraw(redraw);
    }

    public void redraw() {
        this.checkWidget();
        this.internalSetRedraw(true);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width > 0 && height > 0) {
            this.internalSetRedraw(true, x, y, width, height);
        }
    }

    void internalSetRedraw(boolean redraw) {
        this.display.redrawControl(this, redraw);
    }

    void internalSetRedraw(boolean redraw, int x, int y, int width, int height) {
        this.display.redrawControl(this, redraw);
    }

    public void update() {
        this.checkWidget();
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        if (!this.isReparentable()) {
            return false;
        }
        if (this.parent != parent) {
            this.releaseParent();
            Shell newShell = parent.getShell();
            Shell oldShell = this.getShell();
            Decorations newDecorations = parent.menuShell();
            Decorations oldDecorations = this.menuShell();
            if (oldShell != newShell || oldDecorations != newDecorations) {
                this.fixChildren(newShell, oldShell, newDecorations, oldDecorations);
            }
            this.getRemoteAdapter().preserveParent(this.parent);
            ReparentedControls.add(this);
            this.parent = parent;
            parent.addChild(this);
        }
        return true;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.getRemoteAdapter().preserveOrientation(this.style & flags);
        this.style &= 0xF7FFFFFF;
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.updateOrientation();
        this.checkMirrored();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    void updateOrientation() {
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public void addGestureListener(GestureListener listener) {
        this.checkWidget();
    }

    public void removeGestureListener(GestureListener listener) {
        this.checkWidget();
    }

    public void addTouchListener(TouchListener listener) {
        this.checkWidget();
    }

    public void removeTouchListener(TouchListener listener) {
        this.checkWidget();
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.tooltipMarkupEnabled".equals(key) && MarkupUtil.isToolTipMarkupEnabledFor(this)) {
            return;
        }
        if ("org.eclipse.rap.rwt.activeKeys".equals(key)) {
            if (value != null && !(value instanceof String[])) {
                String mesg = "Illegal value for RWT.ACTIVE_KEYS in data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
            ActiveKeysUtil.preserveActiveKeys(this);
        }
        if ("org.eclipse.rap.rwt.cancelKeys".equals(key)) {
            if (value != null && !(value instanceof String[])) {
                String mesg = "Illegal value for RWT.CANCEL_KEYS in data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
            ActiveKeysUtil.preserveCancelKeys(this);
        }
        if ("org.eclipse.rap.rwt.customVariant".equals(key)) {
            this.bufferedPadding = null;
        }
        super.setData(key, value);
    }

    @Override
    void releaseParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    @Override
    void releaseWidget() {
        if (this.menu != null) {
            this.removeMenuDisposeListener();
            this.menu.dispose();
            this.menu = null;
        }
        Shell shell = this.internalGetShell();
        if (this.display.getFocusControl() == this) {
            Composite focusControl = this.parent;
            while (focusControl != null && focusControl.isInDispose()) {
                focusControl = focusControl.getParent();
            }
            if (focusControl != null && focusControl.internalGetShell() != shell) {
                focusControl = null;
            }
            this.setFocusControl(focusControl);
        }
        if (shell.getSavedFocus() == this) {
            shell.setSavedFocus(null);
        }
        this.internalSetRedraw(false);
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        super.releaseWidget();
    }

    boolean isTabGroup() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void setBounds(Rectangle bounds, boolean updateMode) {
        Point oldLocation = this.getLocation();
        Point oldSize = this.getSize();
        this._setBounds(new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height));
        if (updateMode) {
            this.updateMode();
        }
        this.clearPacked(oldSize);
        this.notifyMove(oldLocation);
        this.notifyResize(oldSize);
    }

    void _setBounds(Rectangle rectangle) {
        this.getRemoteAdapter().preserveBounds(this.bounds);
        this.bounds = rectangle;
        this.bounds.width = Math.max(0, this.bounds.width);
        this.bounds.height = Math.max(0, this.bounds.height);
    }

    private void _setMenu(Menu menu) {
        this.getRemoteAdapter().preserveMenu(this.menu);
        this.menu = menu;
    }

    void updateMode() {
    }

    private void clearPacked(Point oldSize) {
        if (!oldSize.equals(this.getSize())) {
            this.packed = false;
        }
    }

    void notifyResize(Point oldSize) {
        if (!oldSize.equals(this.getSize())) {
            this.notifyListeners(11, new Event());
        }
    }

    void notifyMove(Point oldLocation) {
        if (!oldLocation.equals(this.getLocation())) {
            this.notifyListeners(10, new Event());
        }
    }

    private void setFocusControl(Control control) {
        if (control != null) {
            this.display.setActiveShell(control.getShell());
        }
        IDisplayAdapter displayAdapter = this.display.getAdapter(IDisplayAdapter.class);
        displayAdapter.setFocusControl(control, true);
        if (control != null) {
            Shell shell = control.getShell();
            shell.setActiveControl(control);
        }
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFixedFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        IDisplayAdapter displayAdapter = this.display.getAdapter(IDisplayAdapter.class);
        displayAdapter.setFocusControl(null, true);
    }

    boolean setFixedFocus() {
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    boolean isActive() {
        Shell shell = this.getShell();
        boolean result = shell.getEnabled();
        Shell[] allShells = this.getDisplay().getShells();
        int bits = 229376;
        int shellIndex = allShells.length;
        int i = 0;
        while (i < allShells.length && result) {
            if (allShells[i] == shell) {
                shellIndex = i;
            }
            if ((allShells[i].style & bits) != 0 && shellIndex < i) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this);
    }

    private void preserveState(int flag) {
        if ((flag & 8) != 0) {
            this.getRemoteAdapter().preserveEnabled(!this.hasState(8));
        }
        if ((flag & 0x10) != 0) {
            this.getRemoteAdapter().preserveVisible(!this.hasState(16));
        }
    }

    private void addMenuDisposeListener() {
        if (this.menu != null) {
            if (this.menuDisposeListener == null) {
                this.menuDisposeListener = new Listener(){

                    @Override
                    public void handleEvent(Event event) {
                        Control.this._setMenu(null);
                    }
                };
            }
            this.menu.addListener(12, this.menuDisposeListener);
        }
    }

    private void removeMenuDisposeListener() {
        if (this.menu != null) {
            this.menu.removeListener(12, this.menuDisposeListener);
        }
    }

    private ControlRemoteAdapter getRemoteAdapter() {
        return (ControlRemoteAdapter)this.getAdapter(RemoteAdapter.class);
    }

    private final class ControlAdapter
    implements IControlAdapter {
        private ControlAdapter() {
        }

        @Override
        public Shell getShell() {
            return Control.this.internalGetShell();
        }

        @Override
        public int getTabIndex() {
            return Control.this.tabIndex;
        }

        @Override
        public void setTabIndex(int index) {
            if (this.takesFocus()) {
                Control.this.getRemoteAdapter().preserveTabIndex(Control.this.tabIndex);
                Control.this.tabIndex = index;
            }
        }

        private boolean takesFocus() {
            boolean result = (Control.this.getStyle() & 0x80000) == 0;
            result &= Control.this.getClass() != Composite.class;
            result &= Control.this.getClass() != ScrolledComposite.class;
            return result &= Control.this.getClass() != SashForm.class;
        }

        @Override
        public Font getUserFont() {
            return Control.this.font;
        }

        @Override
        public Color getUserForeground() {
            return Control.this.foreground;
        }

        @Override
        public Color getUserBackground() {
            return Control.this.background;
        }

        @Override
        public Image getUserBackgroundImage() {
            return Control.this.backgroundImage;
        }

        @Override
        public boolean getBackgroundTransparency() {
            return Control.this.backgroundTransparency;
        }

        @Override
        public boolean isPacked() {
            return Control.this.packed;
        }

        @Override
        public void clearPacked() {
            Control.this.packed = false;
        }

        @Override
        public Rectangle getBounds() {
            return Control.this.bounds;
        }

        @Override
        public void setForeground(Color color) {
            Control.this.foreground = color;
        }

        @Override
        public void setBackground(Color color) {
            Control.this.background = color;
        }

        @Override
        public void setVisible(boolean visible) {
            Control.this.internalSetVisible(visible);
        }

        @Override
        public void setEnabled(boolean enabled) {
            Control.this.internalSetEnabled(enabled);
        }

        @Override
        public void setToolTipText(String toolTipText) {
            Control.this.toolTipText = toolTipText;
        }

        @Override
        public void setCursor(Cursor cursor) {
            Control.this.cursor = cursor;
        }
    }
}

