/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.http.context;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.framework.Bundle;

@ConsumerType
public abstract class ServletContextHelper {
    public static final String REMOTE_USER = "org.osgi.service.http.authentication.remote.user";
    public static final String AUTHENTICATION_TYPE = "org.osgi.service.http.authentication.type";
    public static final String AUTHORIZATION = "org.osgi.service.useradmin.authorization";
    private final Bundle bundle;

    public ServletContextHelper() {
        this(null);
    }

    public ServletContextHelper(Bundle bundle) {
        this.bundle = bundle;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
    }

    public URL getResource(String name) {
        if (name != null && this.bundle != null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return this.bundle.getEntry(name);
        }
        return null;
    }

    public String getMimeType(String name) {
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        Enumeration e;
        if (path != null && this.bundle != null && (e = this.bundle.findEntries(path, null, false)) != null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            while (e.hasMoreElements()) {
                result.add(((URL)e.nextElement()).getPath());
            }
            return result;
        }
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }
}

