/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.scrollbarkit.ScrollBarLCA;
import org.eclipse.swt.internal.widgets.scrollbarkit.ScrollBarThemeAdapter;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    private final Scrollable parent;
    private int thumb;
    private int selection;
    private int minimum;
    private int maximum;

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setVisible(boolean visible) {
        boolean isVisible;
        this.checkWidget();
        boolean bl = isVisible = !this.hasState(16);
        if (isVisible != visible) {
            if (visible) {
                this.removeState(16);
            } else {
                this.addState(16);
            }
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        return !this.hasState(16);
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            this.removeState(8);
        } else {
            this.addState(8);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return !this.hasState(8);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public Point getSize() {
        Point result = this.parent.getSize();
        if ((this.style & 0x100) != 0) {
            result.y = this.getScrollBarWidth();
        } else {
            result.x = this.getScrollBarWidth();
        }
        return result;
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void setThumb(int thumb) {
        this.checkWidget();
        this.thumb = thumb;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        this.maximum = maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        this.minimum = minimum;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (this.selection != selection) {
            this.selection = selection;
        }
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)ScrollBarLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    private static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    private int getScrollBarWidth() {
        ScrollBarThemeAdapter themeAdapter = (ScrollBarThemeAdapter)this.getAdapter(ThemeAdapter.class);
        return themeAdapter.getScrollBarWidth(this);
    }
}

