/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.celleditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedComboBoxCellEditor
extends ComboBoxCellEditor {
    protected List<?> originalList;
    protected List<?> list;
    protected ILabelProvider labelProvider;
    protected boolean sorted;

    public static boolean select(String filter, String labelValue) {
        if (filter != null && filter.length() > 0) {
            if (filter.length() > labelValue.length()) {
                return false;
            }
            int i = 0;
            while (i < filter.length()) {
                if (Character.toLowerCase(filter.charAt(i)) != Character.toLowerCase(labelValue.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static <T> String[] createItems(List<T> list, ILabelProvider labelProvider, boolean sorted) {
        return ExtendedComboBoxCellEditor.createItems(list, labelProvider, null, sorted);
    }

    public static <T> String[] createItems(List<T> list, ILabelProvider labelProvider, String filter, boolean sorted) {
        String[] result;
        if (filter != null && filter.length() > 0) {
            sorted = true;
        }
        if (list != null && list.size() > 0) {
            if (sorted) {
                ArrayList<T> unsortedList = new ArrayList<T>(list.size());
                if (filter != null && filter.length() > 0) {
                    int i = 0;
                    while (i < list.size()) {
                        if (ExtendedComboBoxCellEditor.select(filter, labelProvider.getText(list.get(i)))) {
                            unsortedList.add(list.get(i));
                        }
                        ++i;
                    }
                } else {
                    unsortedList.addAll(list);
                }
                list.clear();
                Object[] pairs = new StringPositionPair[unsortedList.size()];
                int i = 0;
                int size = unsortedList.size();
                while (i < size) {
                    Object object = unsortedList.get(i);
                    pairs[i] = new StringPositionPair(labelProvider.getText(object), i);
                    ++i;
                }
                Arrays.sort(pairs);
                result = new String[unsortedList.size()];
                i = 0;
                size = unsortedList.size();
                while (i < size) {
                    result[i] = ((StringPositionPair)pairs[i]).key;
                    list.add(unsortedList.get(((StringPositionPair)pairs[i]).position));
                    ++i;
                }
            } else {
                result = new String[list.size()];
                int i = 0;
                int size = list.size();
                while (i < size) {
                    T object = list.get(i);
                    result[i] = labelProvider.getText(object);
                    ++i;
                }
            }
        } else {
            result = new String[]{""};
        }
        return result;
    }

    public ExtendedComboBoxCellEditor(Composite composite, List<?> list, ILabelProvider labelProvider) {
        this(composite, list, labelProvider, false, 8);
    }

    public ExtendedComboBoxCellEditor(Composite composite, List<?> list, ILabelProvider labelProvider, boolean sorted) {
        this(composite, list, labelProvider, sorted, 8);
    }

    public ExtendedComboBoxCellEditor(Composite composite, List<?> list, ILabelProvider labelProvider, int style) {
        this(composite, list, labelProvider, false, style);
    }

    public ExtendedComboBoxCellEditor(Composite composite, List<?> list, ILabelProvider labelProvider, boolean sorted, int style) {
        super(composite, ExtendedComboBoxCellEditor.createItems(sorted ? (list = new ArrayList(list)) : list, labelProvider, null, sorted), style);
        this.originalList = list;
        this.list = list;
        this.labelProvider = labelProvider;
        this.sorted = sorted;
        if ((style & 8) != 0) {
            new FilteringAdapter(this.getControl());
        }
    }

    protected void refreshItems(String filter) {
        CCombo combo = (CCombo)this.getControl();
        if (combo != null && !combo.isDisposed()) {
            ArrayList newList = new ArrayList(this.originalList);
            String[] items = ExtendedComboBoxCellEditor.createItems(newList, this.labelProvider, filter, this.sorted);
            if (!newList.equals(this.list)) {
                Object previousValue = this.getValue();
                this.list = newList;
                combo.setItems(items);
                if (this.list.contains(previousValue)) {
                    this.setValue(previousValue);
                } else if (!this.list.isEmpty()) {
                    this.setValue(this.list.get(0));
                }
            }
        }
    }

    public Object doGetValue() {
        int index = (Integer)super.doGetValue();
        return index < this.list.size() && index >= 0 ? this.list.get((Integer)super.doGetValue()) : null;
    }

    public void doSetValue(Object value) {
        int index = this.list.indexOf(value);
        if (index != -1) {
            super.doSetValue((Object)index);
        }
    }

    public class FilteringAdapter
    implements KeyListener,
    FocusListener {
        private StringBuffer filter = new StringBuffer();

        public FilteringAdapter(Control control) {
            control.addKeyListener((KeyListener)this);
            control.addFocusListener((FocusListener)this);
        }

        private void refreshItems() {
            ExtendedComboBoxCellEditor.this.refreshItems(this.filter.toString());
        }

        public void keyPressed(KeyEvent e) {
            e.doit = false;
            if (e.keyCode == 127 || e.keyCode == 8) {
                if (this.filter.length() > 0) {
                    this.filter = new StringBuffer(this.filter.substring(0, this.filter.length() - 1));
                }
            } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 13 || e.keyCode == 0x1000050 || e.keyCode == 10) {
                e.doit = true;
            } else if (e.keyCode == 27) {
                this.filter = new StringBuffer();
            } else if (e.character != '\u0000') {
                this.filter.append(e.character);
            }
            if (!e.doit) {
                this.refreshItems();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.filter = new StringBuffer();
        }

        public void focusLost(FocusEvent e) {
            this.filter = new StringBuffer();
            this.refreshItems();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringPositionPair
    implements Comparable<StringPositionPair> {
        Comparator<String> comparator = CommonPlugin.INSTANCE.getComparator();
        public String key;
        public int position;

        StringPositionPair(String key, int position) {
            this.key = key;
            this.position = position;
        }

        @Override
        public int compareTo(StringPositionPair object) {
            if (object == this) {
                return 0;
            }
            StringPositionPair that = object;
            return this.comparator.compare(this.key, that.key);
        }
    }
}

