/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

public final class Streams {
    private static final int COPY_BUFFER_SIZE = 8192;
    private static final InputStream CLOSED_INPUT = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private static final OutputStream CLOSED_OUTPUT = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Failed to write: stream is closed");
        }
    };

    private Streams() {
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int rc;
        Objects.requireNonNull(in);
        Objects.requireNonNull(out);
        byte[] buffer = new byte[8192];
        long result = 0L;
        while ((rc = in.read(buffer)) >= 0) {
            result += (long)rc;
            out.write(buffer, 0, rc);
        }
        return result;
    }

    public static long copy(Readable readable, Appendable appendable) throws IOException {
        CharBuffer buffer = CharBuffer.allocate(8192);
        long total = 0L;
        while (readable.read(buffer) >= 0) {
            buffer.flip();
            appendable.append(buffer);
            total += (long)buffer.remaining();
            buffer.clear();
        }
        return total;
    }

    public static String toString(Readable readable) throws IOException {
        StringBuilder builder = new StringBuilder();
        Streams.copy(readable, builder);
        return builder.toString();
    }

    public static String toString(InputStream stream, Charset charset) throws IOException {
        return Streams.toString(new InputStreamReader(stream, charset));
    }

    public static InputStream closedInput() {
        return CLOSED_INPUT;
    }

    public static OutputStream closedOutput() {
        return CLOSED_OUTPUT;
    }
}

