/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter.impl;

import com.google.gson.GsonBuilder;
import java.lang.reflect.AnnotatedElement;
import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.Converter;
import org.eclipse.packagedrone.utils.converter.JSON;

public class JsonToStringConverter
implements Converter {
    public static final JsonToStringConverter INSTANCE = new JsonToStringConverter();

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        return this.canConvert(from, to, null);
    }

    @Override
    public boolean canConvert(Class<?> from, Class<?> to, AnnotatedElement annotatedElement) {
        if (!to.equals(String.class)) {
            return false;
        }
        if (from.isAnnotationPresent(JSON.class)) {
            return true;
        }
        return annotatedElement != null && annotatedElement.isAnnotationPresent(JSON.class);
    }

    @Override
    public String convertTo(Object value, Class<?> clazz, ConversionContext context) {
        if (value == null) {
            return null;
        }
        return new GsonBuilder().create().toJson(value);
    }
}

