/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactory;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryInformation;
import org.eclipse.packagedrone.utils.Holder;
import org.eclipse.packagedrone.utils.osgi.FactoryTracker;
import org.eclipse.packagedrone.utils.osgi.SimpleFactoryTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConfiguredTriggerFactoryTracker {
    public static final String PROP_ID = "drone.trigger.factory.id";
    private final SimpleFactoryTracker<ConfiguredTriggerFactory, ConfiguredTriggerFactoryInformationExt> tracker;

    public ConfiguredTriggerFactoryTracker(BundleContext context) {
        this.tracker = new SimpleFactoryTracker(context, ConfiguredTriggerFactory.class, ref -> FactoryTracker.getString((ServiceReference)ref, (String)PROP_ID), (ref, service) -> new ConfiguredTriggerFactoryInformationExt(FactoryTracker.getString((ServiceReference)ref, (String)PROP_ID), (ConfiguredTriggerFactory)service));
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public void process(String factoryId, Consumer<ConfiguredTriggerFactory> factory) {
        this.tracker.consume(factoryId, entry -> factory.accept(entry.getFactory()));
    }

    public void processOptionally(String factoryId, Consumer<Optional<ConfiguredTriggerFactory>> factory) {
        this.tracker.consumeOptionally(factoryId, entry -> factory.accept(entry.map(ConfiguredTriggerFactoryInformationExt::getFactory)));
    }

    public Optional<ConfiguredTriggerFactoryInformation> getFactoryInformation(String factoryId) {
        Holder result = new Holder(Optional.empty());
        this.tracker.consumeOptionally(factoryId, factory -> {
            Optional<ConfiguredTriggerFactoryInformation> optional = holder.value = Optional.ofNullable(factory.orElse(null));
        });
        return (Optional)result.value;
    }

    public List<ConfiguredTriggerFactoryInformation> getFactoryInformations() {
        ArrayList<ConfiguredTriggerFactoryInformation> result = new ArrayList<ConfiguredTriggerFactoryInformation>();
        this.tracker.consumeAll(stream -> stream.forEach(result::add));
        return result;
    }

    public void addListener(String factoryId, Consumer<ConfiguredTriggerFactory> consumer) {
        this.tracker.addListener(factoryId, this.wrapListener(consumer));
    }

    public void removeListener(String factoryId, Consumer<ConfiguredTriggerFactory> consumer) {
        this.tracker.removeListener(factoryId, this.wrapListener(consumer));
    }

    private Consumer<ConfiguredTriggerFactoryInformationExt> wrapListener(final Consumer<ConfiguredTriggerFactory> consumer) {
        Objects.requireNonNull(consumer);
        return new Consumer<ConfiguredTriggerFactoryInformationExt>(){

            @Override
            public void accept(ConfiguredTriggerFactoryInformationExt t) {
                consumer.accept(t.getFactory());
            }

            public int hashCode() {
                return consumer.hashCode();
            }

            public boolean equals(Object obj) {
                return consumer.equals(obj);
            }
        };
    }

    private static class ConfiguredTriggerFactoryInformationExt
    extends ConfiguredTriggerFactoryInformation {
        private final ConfiguredTriggerFactory factory;

        public ConfiguredTriggerFactoryInformationExt(String id, ConfiguredTriggerFactory factory) {
            super(id, factory.getLabel(), factory.getDescription(), factory.getConfigurationUrl());
            this.factory = factory;
        }

        public ConfiguredTriggerFactory getFactory() {
            return this.factory;
        }
    }
}

