/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.packagedrone.utils.AttributedValue;

public final class Headers {
    private Headers() {
    }

    public static List<AttributedValue> parseList(String string) {
        if (string == null) {
            return null;
        }
        LinkedList<AttributedValue> result = new LinkedList<AttributedValue>();
        String[] stringArray = Headers.split(string, ',');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            result.add(Headers.parse(tok));
            ++n2;
        }
        return result;
    }

    public static <T extends Collection<String>> T parseStringCollection(String string, Supplier<T> provider) {
        List<AttributedValue> result = Headers.parseList(string);
        if (result == null) {
            return null;
        }
        Collection col = (Collection)provider.get();
        for (AttributedValue av : result) {
            col.add(av.getValue());
        }
        return (T)col;
    }

    public static List<String> parseStringList(String string) {
        return Headers.parseStringCollection(string, LinkedList::new);
    }

    public static Set<String> parseStringSet(String string) {
        return Headers.parseStringCollection(string, HashSet::new);
    }

    public static AttributedValue parse(String string) {
        if (string == null) {
            return null;
        }
        String[] toks = Headers.segments(string);
        if (toks.length == 1) {
            return new AttributedValue(toks[0]);
        }
        return new AttributedValue(toks[0], Headers.splitAttributes(1, toks));
    }

    public static Map<String, String> splitAttributes(int skipToks, String[] toks) {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = skipToks;
        while (i < toks.length) {
            Headers.parseToken(toks[i], result);
            ++i;
        }
        return result;
    }

    private static void parseToken(String v, Map<String, String> result) {
        StringBuilder key = new StringBuilder();
        StringBuilder value = null;
        Character quote = null;
        int pos = 0;
        while (pos < v.length()) {
            Character next;
            char c = v.charAt(pos);
            Character c2 = next = pos + 1 < v.length() ? Character.valueOf(v.charAt(pos + 1)) : null;
            if (quote == null) {
                if (c == '\"') {
                    quote = Character.valueOf(c);
                } else if (value != null) {
                    value.append(c);
                } else if (c == ':' && next != null && next.charValue() == '=') {
                    value = new StringBuilder();
                    ++pos;
                } else if (c == '=') {
                    value = new StringBuilder();
                } else {
                    key.append(c);
                }
            } else if (c == quote.charValue()) {
                quote = null;
            } else if (value != null) {
                value.append(c);
            } else {
                key.append(c);
            }
            ++pos;
        }
        if (key.length() <= 0) {
            return;
        }
        if (value != null) {
            result.put(key.toString(), value.toString());
        } else {
            String kv = key.toString();
            result.put(kv, kv);
        }
    }

    public static String[] segments(String string) {
        return Headers.split(string, ';');
    }

    public static String[] split(String string, char delimiter) {
        LinkedList<String> result = new LinkedList<String>();
        int pos = 0;
        Character quote = null;
        StringBuilder sb = new StringBuilder();
        while (pos < string.length()) {
            char c = string.charAt(pos);
            if (quote == null) {
                if (c == '\"') {
                    quote = Character.valueOf(c);
                    sb.append(c);
                } else if (!Character.isWhitespace(c)) {
                    if (c == delimiter) {
                        result.add(sb.toString());
                        sb = new StringBuilder();
                    } else {
                        sb.append(c);
                    }
                }
            } else {
                if (c == quote.charValue()) {
                    quote = null;
                }
                sb.append(c);
            }
            ++pos;
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result.toArray(new String[result.size()]);
    }
}

