/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.internal.menu;

import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.common.internal.table.OsgiTableExtensionManager;
import org.eclipse.packagedrone.web.common.menu.MenuManager;
import org.eclipse.packagedrone.web.common.menu.MenuManagerImpl;
import org.eclipse.packagedrone.web.common.table.TableExtensionManagerRequest;
import org.eclipse.packagedrone.web.interceptor.Interceptor;
import org.osgi.framework.InvalidSyntaxException;

public class MenuInterceptor
implements Interceptor {
    private MenuManagerImpl menuManager;
    private OsgiTableExtensionManager tableExtensionManager;

    public void activate() throws InvalidSyntaxException {
        this.menuManager = new MenuManagerImpl();
        this.tableExtensionManager = new OsgiTableExtensionManager();
        this.tableExtensionManager.start();
    }

    public void deactivate() {
        if (this.menuManager != null) {
            this.menuManager.close();
            this.menuManager = null;
        }
        if (this.tableExtensionManager != null) {
            this.tableExtensionManager.stop();
            this.tableExtensionManager = null;
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.safeSet(request, "menuManager", this.menuManager, MenuManager::new);
        this.safeSet(request, "tableExtensionManager", this.tableExtensionManager, TableExtensionManagerRequest::new);
        return true;
    }

    protected <T, R> void safeSet(HttpServletRequest request, String property, T value, BiFunction<T, HttpServletRequest, R> func) {
        if (value != null && request != null) {
            request.setAttribute(property, func.apply(value, request));
        }
    }
}

