/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.app;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.eclipse.packagedrone.utils.rpm.Architecture;
import org.eclipse.packagedrone.utils.rpm.OperatingSystem;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmLead;
import org.eclipse.packagedrone.utils.rpm.RpmSignatureTag;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.RpmTagValue;
import org.eclipse.packagedrone.utils.rpm.Rpms;
import org.eclipse.packagedrone.utils.rpm.Type;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.packagedrone.utils.rpm.parse.HeaderValue;
import org.eclipse.packagedrone.utils.rpm.parse.InputHeader;
import org.eclipse.packagedrone.utils.rpm.parse.RpmInputStream;

public class Dumper {
    public static String dumpFlag(int value, IntFunction<Optional<?>> func) {
        Optional<?> flag = func.apply(value);
        if (flag.isPresent()) {
            return String.format("%s (%s)", flag.get(), value);
        }
        return String.format("%s", value);
    }

    public static void dumpAll(RpmInputStream in) throws IOException {
        CpioArchiveEntry entry;
        RpmLead lead = in.getLead();
        System.out.format("Version: %s.%s%n", lead.getMajor(), lead.getMinor());
        System.out.format("Name: %s%n", lead.getName());
        System.out.format("Signature Version: %s%n", lead.getSignatureVersion());
        System.out.format("Type: %s, Arch: %s, OS: %s%n", Dumper.dumpFlag(lead.getType(), Type::fromValue), Dumper.dumpFlag(lead.getArchitecture(), Architecture::fromValue), Dumper.dumpFlag(lead.getOperatingSystem(), OperatingSystem::fromValue));
        Dumper.dumpHeader("Signature", in.getSignatureHeader(), tag -> RpmSignatureTag.find(tag), false);
        Dumper.dumpHeader("Payload", in.getPayloadHeader(), tag -> RpmTag.find(tag), false);
        CpioArchiveInputStream cpio = in.getCpioStream();
        while ((entry = cpio.getNextCPIOEntry()) != null) {
            Dumper.dumpEntry(entry);
        }
        String[] names = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.REQUIRE_NAME)).asStringArray().orElse(null);
        String[] versions = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.REQUIRE_VERSION)).asStringArray().orElse(null);
        Integer[] flags = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.REQUIRE_FLAGS)).asIntegerArray().orElse(null);
        Dumper.dumpDeps("Require", names, versions, flags);
        names = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.PROVIDE_NAME)).asStringArray().orElse(null);
        versions = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.PROVIDE_VERSION)).asStringArray().orElse(null);
        flags = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.PROVIDE_FLAGS)).asIntegerArray().orElse(null);
        Dumper.dumpDeps("Provide", names, versions, flags);
        names = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.CONFLICT_NAME)).asStringArray().orElse(null);
        versions = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.CONFLICT_VERSION)).asStringArray().orElse(null);
        flags = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.CONFLICT_FLAGS)).asIntegerArray().orElse(null);
        Dumper.dumpDeps("Conflict", names, versions, flags);
        names = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.OBSOLETE_NAME)).asStringArray().orElse(null);
        versions = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.OBSOLETE_VERSION)).asStringArray().orElse(null);
        flags = new RpmTagValue(in.getPayloadHeader().getTag(RpmTag.OBSOLETE_FLAGS)).asIntegerArray().orElse(null);
        Dumper.dumpDeps("Obsolete", names, versions, flags);
    }

    private static void dumpDeps(String string, String[] names, String[] versions, Integer[] flags) {
        if (names == null) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            System.out.format("%s: %s - %s - %s %s%n", string, names[i], versions[i], flags[i], RpmDependencyFlags.parse(flags[i]));
            ++i;
        }
    }

    private static void dumpHeader(String string, InputHeader<? extends RpmBaseTag> header, Function<Integer, Object> func, boolean sorted) {
        System.out.println(string);
        System.out.println("=================================");
        Set<Map.Entry<Integer, HeaderValue>> data = sorted ? new TreeMap<Integer, HeaderValue>(header.getRawTags()).entrySet() : header.getRawTags().entrySet();
        for (Map.Entry<Integer, HeaderValue> entry : data) {
            Object tag = func.apply(entry.getKey());
            if (tag == null) {
                tag = entry.getKey();
            }
            System.out.format("%20s - %s%n", tag, Rpms.dumpValue(entry.getValue()));
            if (entry.getKey() != 62 && entry.getKey() != 63) continue;
            ByteBuffer buf = ByteBuffer.wrap((byte[])entry.getValue().getValue());
            System.out.format("Immutable - tag: %s, type: %s, position: %s, count: %s%n", buf.getInt(), buf.getInt(), buf.getInt(), buf.getInt());
        }
    }

    private static void dumpEntry(CpioArchiveEntry entry) {
        System.out.format("-----------------------------------%n", new Object[0]);
        System.out.format(" %s%n", entry.getName());
        System.out.format(" Size: %s, Chksum: %016x, Align: %s, Inode: %016x, Mode: %08o, NoL: %s, Device: %s.%s%n", entry.getSize(), entry.getChksum(), entry.getAlignmentBoundary(), entry.getInode(), entry.getMode(), entry.getNumberOfLinks(), entry.getDeviceMaj(), entry.getDeviceMin());
    }

    public static void main(String[] args) throws IOException {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Dumper.dump(Paths.get(file, new String[0]));
            ++n2;
        }
    }

    private static void dump(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.format("%s: does not exist%n", new Object[0]);
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RpmInputStream in = new RpmInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                Dumper.dumpAll(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.format("%s: failed to read file%n", new Object[0]);
            e.printStackTrace(System.err);
        }
    }
}

