/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.aspect;

import java.util.concurrent.Callable;
import org.eclipse.packagedrone.repo.utils.ThrowingRunnable;
import org.eclipse.packagedrone.utils.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Guard {
    private static final Logger logger = LoggerFactory.getLogger(Guard.class);
    private final ThreadLocal<Integer> state = ThreadLocal.withInitial(() -> 0);
    private final Runnable guardRunner;

    public Guard(Runnable guardRunner) {
        this.guardRunner = guardRunner;
    }

    public void guarded(ThrowingRunnable action) {
        this.guarded(() -> {
            action.run();
            return null;
        });
    }

    public <T> T guarded(Callable<T> action) {
        boolean first = this.push();
        logger.trace("run guarded - first: {}", (Object)first);
        try {
            Object result = Exceptions.wrapException(action);
            if (first) {
                logger.debug("execute guard runner");
                this.guardRunner.run();
            }
            Object object = result;
            return (T)object;
        }
        finally {
            this.pop();
        }
    }

    private boolean push() {
        int level = this.state.get();
        this.state.set(level + 1);
        return level == 0;
    }

    private void pop() {
        this.state.set(this.state.get() - 1);
    }
}

