/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.addon.internal;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.packagedrone.addon.AddonDescription;
import org.eclipse.packagedrone.addon.AddonInformation;
import org.eclipse.packagedrone.addon.internal.AddonDescriptor;
import org.eclipse.packagedrone.addon.internal.AddonRegistration;
import org.eclipse.packagedrone.utils.io.CloseShieldInputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAddonRegistration
implements AddonRegistration {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAddonRegistration.class);
    private final Path path;
    private final String id;
    private volatile State state;

    public DefaultAddonRegistration(Path path) {
        this.path = path;
        this.id = path.getFileName().toString();
        this.state = DefaultAddonRegistration.load(path);
    }

    private static State load(Path path) {
        try {
            return new Stopped(path, DefaultAddonRegistration.loadDescription(path));
        }
        catch (Throwable e) {
            return new Invalid(path, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AddonDescription loadDescription(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            AddonDescription addonDescription;
            ZipInputStream zis = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                block6: while (true) {
                    ZipEntry ze;
                    if ((ze = zis.getNextEntry()) == null) {
                        throw new RuntimeException("Addon is missing the 'addon.json' descriptor");
                    }
                    String name = ze.getName();
                    while (true) {
                        if (!name.startsWith("/")) {
                            if (!name.equals("addon.json")) continue block6;
                            addonDescription = DefaultAddonRegistration.parseDescription(zis);
                            return addonDescription;
                        }
                        name = name.substring(1);
                    }
                    break;
                }
            }
            finally {
                if (zis == null) return addonDescription;
                zis.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static AddonDescription parseDescription(InputStream stream) {
        Version version;
        GsonBuilder builder = new GsonBuilder();
        AddonDescriptor desc = (AddonDescriptor)builder.create().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), AddonDescriptor.class);
        if (desc == null) {
            throw new RuntimeException("Failed to read descriptor");
        }
        if (desc.getId() == null || desc.getId().isEmpty()) {
            throw new RuntimeException("Descriptor is missing the field 'name'");
        }
        if (desc.getVersion() == null || desc.getVersion().isEmpty()) {
            throw new RuntimeException("Descriptor is missing the field 'version'");
        }
        try {
            version = Version.valueOf((String)desc.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid version: " + desc.getVersion(), e);
        }
        String label = desc.getLabel();
        if (label == null || label.isEmpty()) {
            label = String.valueOf(desc.getId()) + ":" + desc.getVersion();
        }
        return new AddonDescription(desc.getId(), version, label);
    }

    private static State tryStart(Path path, AddonDescription description) {
        try {
            return new Started(path, description);
        }
        catch (StartFailedException e) {
            return new Failed(path, e, description, e.getStateInformation());
        }
        catch (IOException e) {
            return new Invalid(path, e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AddonInformation getInformation() {
        return this.state.getInformation();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void start() {
        this.state = this.state.start();
    }

    @Override
    public void stop() {
        this.state = this.state.stop();
    }

    public static class Failed
    implements State {
        private final Throwable error;
        private final AddonDescription description;
        private final Path path;
        private final String stateInformation;

        public Failed(Path path, Throwable e, AddonDescription description, String stateInformation) {
            this.path = path;
            this.error = e;
            this.description = description;
            this.stateInformation = stateInformation;
        }

        @Override
        public AddonInformation getInformation() {
            return new AddonInformation(org.eclipse.packagedrone.addon.State.FAILED, this.description, this.error, this.stateInformation);
        }

        @Override
        public State start() {
            return DefaultAddonRegistration.tryStart(this.path, this.description);
        }

        @Override
        public State stop() {
            return this;
        }
    }

    public static class Invalid
    implements State {
        private final Throwable error;
        private final AddonDescription description;
        private final Path path;

        public Invalid(Path path, Throwable e) {
            this.path = path;
            this.error = e;
            this.description = new AddonDescription("unknwown", Version.emptyVersion, "n/a");
        }

        @Override
        public AddonInformation getInformation() {
            return new AddonInformation(org.eclipse.packagedrone.addon.State.FAILED, this.description, this.error, null);
        }

        @Override
        public State start() {
            return DefaultAddonRegistration.load(this.path);
        }

        @Override
        public State stop() {
            return this;
        }
    }

    private static class StartFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String stateInformation;

        public StartFailedException(String message, Throwable cause, String stateInformation) {
            super(message, cause);
            this.stateInformation = stateInformation;
        }

        public String getStateInformation() {
            return this.stateInformation;
        }
    }

    public static class Started
    implements State {
        private final Path path;
        private final AddonDescription description;
        private final List<Bundle> bundles;
        private final String stateInformation;

        public Started(Path path, AddonDescription description) throws IOException {
            LinkedList<Bundle> bundles;
            PrintWriter pw;
            StringWriter sw;
            block16: {
                this.path = path;
                this.description = description;
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                bundles = new LinkedList<Bundle>();
                BundleContext context = FrameworkUtil.getBundle(Started.class).getBundleContext();
                Throwable throwable = null;
                Object var8_9 = null;
                try {
                    ZipInputStream zis = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));
                    block9: while (true) {
                        ZipEntry ze;
                        while ((ze = zis.getNextEntry()) != null) {
                            String name = ze.getName();
                            if (!name.endsWith(".jar")) continue;
                            try {
                                Bundle bundle = context.installBundle(String.valueOf(path.toAbsolutePath().toString()) + "/" + name, (InputStream)new CloseShieldInputStream((InputStream)zis));
                                pw.format("Installed bundle: %s -> %s - %s/%s, state: %s%n", name, bundle.getBundleId(), bundle.getSymbolicName(), bundle.getVersion(), this.makeState(bundle.getState()));
                                bundles.add(bundle);
                                continue block9;
                            }
                            catch (BundleException e) {
                                pw.format("Failed to install bundle: %s%n", name);
                                Started.uninstall(pw, bundles);
                                throw new StartFailedException("Failed to start addon - installing", e, sw.toString());
                            }
                        }
                        break block16;
                        {
                            continue block9;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (zis != null) {
                            zis.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            LinkedList<Bundle> started = new LinkedList<Bundle>();
            for (Bundle bundle : bundles) {
                try {
                    bundle.start();
                    started.add(bundle);
                }
                catch (BundleException e) {
                    logger.warn("Failed to start bundle", (Throwable)e);
                    pw.format("Failed to start bundle: %s%n", bundle.getBundleId());
                    e.printStackTrace(pw);
                    Started.uninstall(pw, bundles);
                    throw new StartFailedException("Failed to start addon - starting", e, sw.toString());
                }
            }
            this.bundles = bundles;
            this.stateInformation = sw.toString();
        }

        private static void uninstall(PrintWriter pw, List<Bundle> bundles) {
            for (Bundle b : bundles) {
                try {
                    pw.format("Uninstalling bundle: %s%n", b.getBundleId());
                    b.uninstall();
                }
                catch (BundleException e1) {
                    pw.format("Failed uninstalling bundle: %s%n", b.getBundleId());
                    e1.printStackTrace(pw);
                }
            }
            bundles.clear();
        }

        private String makeState(int state) {
            switch (state) {
                case 32: {
                    return "ACTIVE";
                }
                case 2: {
                    return "INSTALLED";
                }
                case 4: {
                    return "RESOLVED";
                }
                case 8: {
                    return "STARTING";
                }
                case 16: {
                    return "STOPPING";
                }
                case 1: {
                    return "UNINSTALLED";
                }
            }
            return Integer.toString(state);
        }

        @Override
        public AddonInformation getInformation() {
            return new AddonInformation(org.eclipse.packagedrone.addon.State.ACTIVE, this.description, null, this.stateInformation);
        }

        @Override
        public State start() {
            return this;
        }

        @Override
        public State stop() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Started.uninstall(pw, this.bundles);
            return new Stopped(this.path, this.description, sw.toString());
        }
    }

    private static interface State {
        public AddonInformation getInformation();

        public State start();

        public State stop();
    }

    public static class Stopped
    implements State {
        private final Path path;
        private final AddonDescription description;
        private final String stateInformation;

        public Stopped(Path path, AddonDescription description) {
            this.path = path;
            this.description = description;
            this.stateInformation = null;
        }

        public Stopped(Path path, AddonDescription description, String stateInformation) {
            this.path = path;
            this.description = description;
            this.stateInformation = stateInformation;
        }

        @Override
        public AddonInformation getInformation() {
            return new AddonInformation(org.eclipse.packagedrone.addon.State.INSTALLED, this.description, null, this.stateInformation);
        }

        @Override
        public State start() {
            return DefaultAddonRegistration.tryStart(this.path, this.description);
        }

        @Override
        public State stop() {
            return this;
        }
    }
}

